/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.named.spi.RowReaderMemento;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.exec.spi.RowTransformer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.sql.results.spi.RowReader;
import org.jboss.logging.Logger;

public class RowReaderStandardImpl<T>
implements RowReader<T> {
    private static final Logger LOG = Logger.getLogger(RowReaderStandardImpl.class);
    private final List<DomainResultAssembler> resultAssemblers;
    private final List<Initializer> initializers;
    private final RowTransformer<T> rowTransformer;
    private final int assemblerCount;
    private final Callback callback;

    public RowReaderStandardImpl(List<DomainResultAssembler> resultAssemblers, List<Initializer> initializers, RowTransformer<T> rowTransformer, Callback callback) {
        this.resultAssemblers = resultAssemblers;
        this.initializers = initializers;
        this.rowTransformer = rowTransformer;
        this.assemblerCount = resultAssemblers.size();
        this.callback = callback;
    }

    @Override
    public Class<T> getResultJavaType() {
        if (this.resultAssemblers.size() == 1) {
            return this.resultAssemblers.get(0).getJavaTypeDescriptor().getJavaType();
        }
        return Object[].class;
    }

    @Override
    public List<Initializer> getInitializers() {
        return this.initializers;
    }

    @Override
    public int getNumberOfResults() {
        return this.rowTransformer.determineNumberOfResultElements(this.assemblerCount);
    }

    @Override
    public T readRow(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        LOG.info((Object)"---Processing Row---");
        this.coordinateInitializers(rowProcessingState, options);
        Object[] result = new Object[this.assemblerCount];
        for (int i = 0; i < this.assemblerCount; ++i) {
            result[i] = this.resultAssemblers.get(i).assemble(rowProcessingState, options);
        }
        this.afterRow(rowProcessingState, options);
        return this.rowTransformer.transformRow(result);
    }

    private void afterRow(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        for (Initializer initializer : this.initializers) {
            initializer.finishUpRow(rowProcessingState);
        }
    }

    private void coordinateInitializers(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        for (Initializer initializer : this.initializers) {
            initializer.resolveKey(rowProcessingState);
        }
        for (Initializer initializer : this.initializers) {
            initializer.resolveInstance(rowProcessingState);
        }
        for (Initializer initializer : this.initializers) {
            initializer.initializeInstance(rowProcessingState);
        }
    }

    @Override
    public void finishUp(JdbcValuesSourceProcessingState processingState) {
        for (Initializer initializer : this.initializers) {
            initializer.endLoading(processingState.getExecutionContext());
        }
    }

    @Override
    public RowReaderMemento toMemento(SessionFactoryImplementor factory) {
        return new RowReaderMemento(){

            @Override
            public Class[] getResultClasses() {
                return new Class[0];
            }

            @Override
            public String[] getResultMappingNames() {
                return new String[0];
            }
        };
    }
}

