/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.Objects;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.spi.SqlSelection;

public class SqlSelectionImpl
implements SqlSelection {
    private final int jdbcPosition;
    private final int valuesArrayPosition;
    private final Expression sqlExpression;
    private final JdbcValueExtractor jdbcValueExtractor;

    public SqlSelectionImpl(int jdbcPosition, int valuesArrayPosition, Expression sqlExpression, SqlExpressableType sqlExpressableType) {
        this(jdbcPosition, valuesArrayPosition, sqlExpression, sqlExpressableType.getJdbcValueExtractor());
    }

    public SqlSelectionImpl(int jdbcPosition, int valuesArrayPosition, Expression sqlExpression, JdbcValueExtractor jdbcValueExtractor) {
        this.jdbcPosition = jdbcPosition;
        this.valuesArrayPosition = valuesArrayPosition;
        this.sqlExpression = sqlExpression;
        this.jdbcValueExtractor = jdbcValueExtractor;
    }

    @Override
    public JdbcValueExtractor getJdbcValueExtractor() {
        return this.jdbcValueExtractor;
    }

    @Override
    public int getJdbcResultSetIndex() {
        return this.jdbcPosition;
    }

    @Override
    public int getValuesArrayPosition() {
        return this.valuesArrayPosition;
    }

    @Override
    public void accept(SqlAstWalker interpreter) {
        this.sqlExpression.accept(interpreter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlSelectionImpl that = (SqlSelectionImpl)o;
        return this.jdbcPosition == that.jdbcPosition && this.valuesArrayPosition == that.valuesArrayPosition && Objects.equals(this.sqlExpression, that.sqlExpression);
    }

    public int hashCode() {
        return Objects.hash(this.jdbcPosition, this.valuesArrayPosition, this.sqlExpression);
    }
}

