/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.annotations.Remove;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.spi.ConvertibleNavigable;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.sql.results.spi.SqlSelectionReader;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

@Deprecated
@Remove
public class SqlSelectionReaderImpl
implements SqlSelectionReader {
    private final Reader reader;

    public SqlSelectionReaderImpl(int jdbcTypeCode) {
        this.reader = new JdbcTypeCodeReaderImpl(jdbcTypeCode);
    }

    public SqlSelectionReaderImpl(BasicValuedExpressableType expressableType) {
        this.reader = new BasicTypeReaderAdapterImpl(expressableType);
    }

    public SqlSelectionReaderImpl(BasicValuedExpressableType basicType, int jdbcTypeCode) {
        this.reader = basicType != null ? new BasicTypeReaderAdapterImpl(basicType) : new JdbcTypeCodeReaderImpl(jdbcTypeCode);
    }

    public Object read(ResultSet resultSet, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, SqlSelection sqlSelection) throws SQLException {
        return this.reader.read(resultSet, jdbcValuesSourceProcessingState, sqlSelection.getJdbcResultSetIndex());
    }

    public Object extractParameterValue(CallableStatement statement, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, int jdbcParameterIndex) throws SQLException {
        return this.reader.readParameterValue(statement, jdbcValuesSourceProcessingState, jdbcParameterIndex);
    }

    public Object extractParameterValue(CallableStatement statement, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, String jdbcParameterName) throws SQLException {
        return this.reader.readParameterValue(statement, jdbcValuesSourceProcessingState, jdbcParameterName);
    }

    private static <T> T extractRawJdbcValue(ResultSet resultSet, BasicJavaDescriptor<T> javaTypeDescriptor, SqlTypeDescriptor sqlTypeDescriptor, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, int jdbcParameterIndex) throws SQLException {
        assert (resultSet != null);
        assert (javaTypeDescriptor != null);
        assert (sqlTypeDescriptor != null);
        assert (jdbcValuesSourceProcessingState != null);
        assert (jdbcParameterIndex > 0);
        SharedSessionContractImplementor session = jdbcValuesSourceProcessingState.getSession();
        return (T)sqlTypeDescriptor.getSqlExpressableType(javaTypeDescriptor, session.getFactory().getTypeConfiguration()).getJdbcValueExtractor().extract(resultSet, jdbcParameterIndex, jdbcValuesSourceProcessingState.getExecutionContext());
    }

    private static <T> T extractRawJdbcParameterValue(CallableStatement statement, BasicJavaDescriptor<T> javaTypeDescriptor, SqlTypeDescriptor sqlTypeDescriptor, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, int jdbcParameterIndex) throws SQLException {
        assert (statement != null);
        assert (javaTypeDescriptor != null);
        assert (sqlTypeDescriptor != null);
        assert (jdbcValuesSourceProcessingState != null);
        SharedSessionContractImplementor session = jdbcValuesSourceProcessingState.getSession();
        return (T)sqlTypeDescriptor.getSqlExpressableType(javaTypeDescriptor, session.getFactory().getTypeConfiguration()).getJdbcValueExtractor().extract(statement, jdbcParameterIndex, jdbcValuesSourceProcessingState.getExecutionContext());
    }

    private static <T> T extractRawJdbcParameterValue(CallableStatement statement, BasicJavaDescriptor<T> javaTypeDescriptor, SqlTypeDescriptor sqlTypeDescriptor, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, String jdbcParameterName) throws SQLException {
        assert (statement != null);
        assert (javaTypeDescriptor != null);
        assert (sqlTypeDescriptor != null);
        assert (jdbcValuesSourceProcessingState != null);
        SharedSessionContractImplementor session = jdbcValuesSourceProcessingState.getSession();
        return (T)sqlTypeDescriptor.getSqlExpressableType(javaTypeDescriptor, session.getFactory().getTypeConfiguration()).getJdbcValueExtractor().extract(statement, jdbcParameterName, jdbcValuesSourceProcessingState.getExecutionContext());
    }

    private static <T> BasicJavaDescriptor<T> determineJavaTypeDescriptor(BasicValuedExpressableType expressableType) {
        BasicValueConverter valueConverter;
        if (expressableType instanceof ConvertibleNavigable && (valueConverter = ((ConvertibleNavigable)((Object)expressableType)).getValueConverter()) != null) {
            return valueConverter.getDomainJavaDescriptor();
        }
        return expressableType.getJavaTypeDescriptor();
    }

    private class BasicTypeReaderAdapterImpl
    implements Reader {
        private final BasicValuedExpressableType expressableType;

        public BasicTypeReaderAdapterImpl(BasicValuedExpressableType expressableType) {
            this.expressableType = expressableType;
        }

        public Object read(ResultSet resultSet, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, int position) throws SQLException {
            return SqlSelectionReaderImpl.extractRawJdbcValue(resultSet, SqlSelectionReaderImpl.determineJavaTypeDescriptor(this.expressableType), this.expressableType.getSqlTypeDescriptor(), jdbcValuesSourceProcessingState, position);
        }

        @Override
        public <T> T readParameterValue(CallableStatement statement, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, int jdbcParameterIndex) throws SQLException {
            return (T)SqlSelectionReaderImpl.extractRawJdbcParameterValue(statement, SqlSelectionReaderImpl.determineJavaTypeDescriptor(this.expressableType), this.expressableType.getSqlTypeDescriptor(), jdbcValuesSourceProcessingState, jdbcParameterIndex);
        }

        @Override
        public <T> T readParameterValue(CallableStatement statement, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, String jdbcParameterName) throws SQLException {
            return (T)SqlSelectionReaderImpl.extractRawJdbcParameterValue(statement, SqlSelectionReaderImpl.determineJavaTypeDescriptor(this.expressableType), this.expressableType.getSqlTypeDescriptor(), jdbcValuesSourceProcessingState, jdbcParameterName);
        }
    }

    static class JdbcTypeCodeReaderImpl
    implements Reader {
        private final int jdbcTypeCode;

        public JdbcTypeCodeReaderImpl(int jdbcTypeCode) {
            this.jdbcTypeCode = jdbcTypeCode;
        }

        public Object read(ResultSet resultSet, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, int position) throws SQLException {
            SqlTypeDescriptor sqlDescriptor = jdbcValuesSourceProcessingState.getSession().getFactory().getMetamodel().getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(this.jdbcTypeCode);
            BasicJavaDescriptor javaTypeDescriptor = sqlDescriptor.getJdbcRecommendedJavaTypeMapping(jdbcValuesSourceProcessingState.getSession().getFactory().getMetamodel().getTypeConfiguration());
            return SqlSelectionReaderImpl.extractRawJdbcValue(resultSet, javaTypeDescriptor, sqlDescriptor, jdbcValuesSourceProcessingState, position);
        }

        @Override
        public <T> T readParameterValue(CallableStatement statement, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, int jdbcParameterIndex) throws SQLException {
            SqlTypeDescriptor sqlDescriptor = jdbcValuesSourceProcessingState.getSession().getFactory().getMetamodel().getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(this.jdbcTypeCode);
            BasicJavaDescriptor javaTypeDescriptor = sqlDescriptor.getJdbcRecommendedJavaTypeMapping(jdbcValuesSourceProcessingState.getSession().getFactory().getMetamodel().getTypeConfiguration());
            return (T)SqlSelectionReaderImpl.extractRawJdbcParameterValue(statement, javaTypeDescriptor, sqlDescriptor, jdbcValuesSourceProcessingState, jdbcParameterIndex);
        }

        @Override
        public <T> T readParameterValue(CallableStatement statement, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, String jdbcParameterName) throws SQLException {
            SqlTypeDescriptor sqlDescriptor = jdbcValuesSourceProcessingState.getSession().getFactory().getMetamodel().getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(this.jdbcTypeCode);
            BasicJavaDescriptor javaTypeDescriptor = sqlDescriptor.getJdbcRecommendedJavaTypeMapping(jdbcValuesSourceProcessingState.getSession().getFactory().getMetamodel().getTypeConfiguration());
            return (T)SqlSelectionReaderImpl.extractRawJdbcParameterValue(statement, javaTypeDescriptor, sqlDescriptor, jdbcValuesSourceProcessingState, jdbcParameterName);
        }
    }

    private static interface Reader {
        public <T> T read(ResultSet var1, JdbcValuesSourceProcessingState var2, int var3) throws SQLException;

        public <T> T readParameterValue(CallableStatement var1, JdbcValuesSourceProcessingState var2, int var3) throws SQLException;

        public <T> T readParameterValue(CallableStatement var1, JdbcValuesSourceProcessingState var2, String var3) throws SQLException;
    }
}

