/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.ResultSetMapping;
import org.hibernate.sql.results.spi.SqlSelection;

public class StandardResultSetMapping
implements ResultSetMapping {
    private final Set<SqlSelection> sqlSelections;
    private final List<DomainResult> domainResults;

    public StandardResultSetMapping(Set<SqlSelection> sqlSelections, List<DomainResult> domainResults) {
        this.sqlSelections = sqlSelections;
        this.domainResults = domainResults;
    }

    @Override
    public Set<SqlSelection> getSqlSelections() {
        return this.sqlSelections;
    }

    @Override
    public List<DomainResult> getDomainResults() {
        return this.domainResults;
    }

    @Override
    public List<DomainResultAssembler> resolveAssemblers(Consumer<Initializer> initializerConsumer, AssemblerCreationState creationState) {
        ArrayList<DomainResultAssembler> assemblers = CollectionHelper.arrayList(this.domainResults.size());
        for (DomainResult domainResult : this.domainResults) {
            DomainResultAssembler resultAssembler = domainResult.createResultAssembler(initializerConsumer, creationState);
            assemblers.add(resultAssembler);
        }
        return assemblers;
    }
}

