/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain;

import java.util.Collections;
import java.util.List;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;

public abstract class AbstractFetchParent
implements FetchParent {
    private final NavigableContainer fetchContainer;
    private final NavigablePath navigablePath;
    private List<Fetch> fetches;

    public AbstractFetchParent(NavigableContainer fetchContainer, NavigablePath navigablePath) {
        this.fetchContainer = fetchContainer;
        this.navigablePath = navigablePath;
    }

    protected void afterInitialize(DomainResultCreationState creationState) {
        this.fetches = creationState.visitFetches(this);
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public NavigableContainer getNavigableContainer() {
        return this.fetchContainer;
    }

    @Override
    public List<Fetch> getFetches() {
        return this.fetches == null ? Collections.emptyList() : Collections.unmodifiableList(this.fetches);
    }

    @Override
    public Fetch findFetch(String fetchableName) {
        if (this.fetches != null) {
            for (Fetch fetch : this.fetches) {
                if (!fetch.getFetchedNavigableName().equals(fetchableName)) continue;
                return fetch;
            }
        }
        return null;
    }
}

