/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.query.sqm.tree.expression.Compatibility;
import org.hibernate.sql.ast.tree.expression.instantiation.ArgumentDomainResult;
import org.hibernate.sql.ast.tree.expression.instantiation.DynamicInstantiationNature;
import org.hibernate.sql.results.internal.instantiation.ArgumentReader;
import org.hibernate.sql.results.internal.instantiation.DynamicInstantiationConstructorAssemblerImpl;
import org.hibernate.sql.results.internal.instantiation.DynamicInstantiationInjectionAssemblerImpl;
import org.hibernate.sql.results.internal.instantiation.DynamicInstantiationListAssemblerImpl;
import org.hibernate.sql.results.internal.instantiation.DynamicInstantiationMapAssemblerImpl;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.DynamicInstantiationResult;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.jboss.logging.Logger;

public class DynamicInstantiationResultImpl
implements DynamicInstantiationResult {
    private static final Logger log = Logger.getLogger(DynamicInstantiationResultImpl.class);
    private final String resultVariable;
    private final DynamicInstantiationNature nature;
    private final JavaTypeDescriptor<Object> javaTypeDescriptor;
    private final List<ArgumentDomainResult> argumentResults;

    public DynamicInstantiationResultImpl(String resultVariable, DynamicInstantiationNature nature, JavaTypeDescriptor<Object> javaTypeDescriptor, List<ArgumentDomainResult> argumentResults) {
        this.resultVariable = resultVariable;
        this.nature = nature;
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.argumentResults = argumentResults;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public DomainResultAssembler createResultAssembler(Consumer<Initializer> initializerConsumer, AssemblerCreationState creationState) {
        boolean areAllArgumentsAliased = true;
        boolean areAnyArgumentsAliased = false;
        HashSet<String> aliases = new HashSet<String>();
        ArrayList<String> duplicatedAliases = new ArrayList<String>();
        ArrayList<ArgumentReader> argumentReaders = new ArrayList<ArgumentReader>();
        if (this.argumentResults != null) {
            for (ArgumentDomainResult argumentResult : this.argumentResults) {
                String argumentAlias = argumentResult.getResultVariable();
                if (argumentAlias == null) {
                    areAllArgumentsAliased = false;
                } else {
                    if (!aliases.add(argumentAlias)) {
                        duplicatedAliases.add(argumentAlias);
                        log.debugf("Query defined duplicate resultVariable encountered multiple declarations of [%s]", (Object)argumentAlias);
                    }
                    areAnyArgumentsAliased = true;
                }
                argumentReaders.add((ArgumentReader)argumentResult.createResultAssembler((Consumer)initializerConsumer, creationState));
            }
        }
        DomainResultAssembler assembler = this.resolveAssembler(areAllArgumentsAliased, areAnyArgumentsAliased, duplicatedAliases, argumentReaders, creationState);
        return assembler;
    }

    private DomainResultAssembler resolveAssembler(boolean areAllArgumentsAliased, boolean areAnyArgumentsAliased, List<String> duplicatedAliases, List<ArgumentReader> argumentReaders, AssemblerCreationState creationState) {
        if (this.nature == DynamicInstantiationNature.LIST) {
            if (log.isDebugEnabled() && areAnyArgumentsAliased) {
                log.debug((Object)"One or more arguments for List dynamic instantiation (`new list(...)`) specified an alias; ignoring");
            }
            return new DynamicInstantiationListAssemblerImpl((BasicJavaDescriptor)this.javaTypeDescriptor, argumentReaders);
        }
        if (this.nature == DynamicInstantiationNature.MAP) {
            if (!areAllArgumentsAliased) {
                throw new IllegalStateException("Map dynamic instantiation contained one or more arguments with no alias");
            }
            if (!duplicatedAliases.isEmpty()) {
                throw new IllegalStateException("Map dynamic instantiation contained arguments with duplicated aliases [" + StringHelper.join(",", duplicatedAliases) + "]");
            }
            return new DynamicInstantiationMapAssemblerImpl((BasicJavaDescriptor)this.javaTypeDescriptor, argumentReaders);
        }
        block0: for (Constructor<?> constructor : this.javaTypeDescriptor.getJavaType().getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != argumentReaders.size()) continue;
            for (int i = 0; i < argumentReaders.size(); ++i) {
                ArgumentReader argumentReader = argumentReaders.get(i);
                JavaTypeDescriptor<?> argumentTypeDescriptor = creationState.getSqlAstCreationContext().getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(constructor.getParameterTypes()[i]);
                boolean assignmentCompatible = Compatibility.areAssignmentCompatible(argumentTypeDescriptor, argumentReader.getJavaTypeDescriptor());
                if (assignmentCompatible) continue;
                log.debugf("Skipping constructor for dynamic-instantiation match due to argument mismatch [%s] : %s -> %s", i, (Object)constructor.getParameterTypes()[i].getName(), (Object)argumentTypeDescriptor.getJavaType().getName());
                continue block0;
            }
            constructor.setAccessible(true);
            return new DynamicInstantiationConstructorAssemblerImpl(constructor, this.javaTypeDescriptor, argumentReaders);
        }
        log.debugf("Could not locate appropriate constructor for dynamic instantiation of [%s]; attempting bean-injection instantiation", (Object)this.javaTypeDescriptor.getJavaType().getName());
        if (!areAllArgumentsAliased) {
            throw new IllegalStateException("Could not determine appropriate instantiation strategy - no matching constructor found and one or more arguments did not define alias for bean-injection");
        }
        if (!duplicatedAliases.isEmpty()) {
            throw new IllegalStateException("Could not determine appropriate instantiation strategy - no matching constructor found and arguments defined duplicated aliases [" + StringHelper.join(",", duplicatedAliases) + "] for bean-injection");
        }
        return new DynamicInstantiationInjectionAssemblerImpl(this.javaTypeDescriptor, argumentReaders);
    }
}

