/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.basic;

import java.util.function.Consumer;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.spi.BasicValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.ConvertibleNavigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.produce.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.internal.domain.basic.BasicResultAssembler;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.SqlSelection;

public class BasicFetch
implements Fetch {
    private final FetchParent fetchParent;
    private final BasicValuedNavigable<?> navigable;
    private final FetchTiming fetchTiming;
    private final SqlSelection sqlSelection;
    private final NavigablePath path;

    public BasicFetch(FetchParent fetchParent, BasicValuedNavigable<?> navigable, FetchTiming fetchTiming, DomainResultCreationState creationState) {
        this.fetchParent = fetchParent;
        this.navigable = navigable;
        this.fetchTiming = fetchTiming;
        this.path = fetchParent.getNavigablePath().append(navigable.getNavigableName());
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlExpressionResolver();
        TableGroup tableGroup = creationState.getFromClauseAccess().findTableGroup(fetchParent.getNavigablePath());
        Expression expression = sqlExpressionResolver.resolveSqlExpression(tableGroup, this.getFetchedNavigable().getBoundColumn());
        this.sqlSelection = sqlExpressionResolver.resolveSqlSelection(expression, this.getFetchedNavigable().getSqlExpressableType().getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public BasicValuedNavigable<?> getFetchedNavigable() {
        return this.navigable;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.path;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, Consumer<Initializer> collector, AssemblerCreationState creationState) {
        BasicValueConverter valueConverter = null;
        if (this.getFetchedNavigable() instanceof ConvertibleNavigable) {
            valueConverter = ((ConvertibleNavigable)this.getFetchedNavigable()).getValueConverter();
        }
        return new BasicResultAssembler(this.sqlSelection, valueConverter, this.getFetchedNavigable().getJavaTypeDescriptor());
    }
}

