/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.basic;

import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.jboss.logging.Logger;

public class BasicResultAssembler
implements DomainResultAssembler {
    private static final Logger LOG = Logger.getLogger(BasicResultAssembler.class);
    private final SqlSelection sqlSelection;
    private final BasicValueConverter valueConverter;
    private final JavaTypeDescriptor javaTypeDescriptor;

    public BasicResultAssembler(SqlSelection sqlSelection, BasicValueConverter valueConverter, JavaTypeDescriptor javaTypeDescriptor) {
        this.sqlSelection = sqlSelection;
        this.valueConverter = valueConverter;
        this.javaTypeDescriptor = valueConverter != null ? valueConverter.getRelationalJavaDescriptor() : javaTypeDescriptor;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    @Override
    public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        Object value = rowProcessingState.getJdbcValue(this.sqlSelection);
        LOG.infof("Extracted value [Position %d] - [%s]", (Object)this.sqlSelection.getValuesArrayPosition(), value);
        if (this.valueConverter != null) {
            assert (value == null || this.valueConverter.getRelationalJavaDescriptor().getJavaType().isInstance(value)) : "Expecting raw JDBC value of type [" + this.valueConverter.getRelationalJavaDescriptor().getJavaType().getName() + "] but found [" + value + ']';
            value = this.valueConverter.toDomainValue(value, rowProcessingState.getJdbcValuesSourceProcessingState().getSession());
        }
        return value;
    }
}

