/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.basic;

import java.util.function.Consumer;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.spi.ConvertibleNavigable;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.results.internal.domain.basic.BasicResultAssembler;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.ScalarResult;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;

public class BasicResultImpl
implements ScalarResult {
    private final String resultVariable;
    private final SqlExpressableType expressableType;
    private final DomainResultAssembler assembler;

    public BasicResultImpl(String resultVariable, SqlSelection sqlSelection, SqlExpressableType expressableType) {
        this.resultVariable = resultVariable;
        this.expressableType = expressableType;
        BasicValueConverter valueConverter = null;
        if (expressableType instanceof ConvertibleNavigable) {
            valueConverter = ((ConvertibleNavigable)((Object)expressableType)).getValueConverter();
        }
        this.assembler = new BasicResultAssembler(sqlSelection, valueConverter, expressableType.getJavaTypeDescriptor());
    }

    public BasicResultImpl(String resultVariable, SqlSelection sqlSelection, SqlExpressableType expressableType, BasicValueConverter valueConverter) {
        this.resultVariable = resultVariable;
        this.expressableType = expressableType;
        this.assembler = new BasicResultAssembler(sqlSelection, valueConverter, expressableType.getJavaTypeDescriptor());
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public BasicJavaDescriptor getJavaTypeDescriptor() {
        return this.expressableType.getJavaTypeDescriptor();
    }

    @Override
    public DomainResultAssembler createResultAssembler(Consumer<Initializer> initializerCollector, AssemblerCreationState creationState) {
        return this.assembler;
    }
}

