/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.CollectionLoadingLogger;
import org.hibernate.sql.results.spi.CollectionInitializer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.RowProcessingState;

public abstract class AbstractCollectionInitializer
implements CollectionInitializer {
    private final PersistentCollectionDescriptor collectionDescriptor;
    private final FetchParentAccess parentAccess;
    private final NavigablePath navigablePath;
    private final boolean selected;
    private final DomainResultAssembler keyTargetAssembler;
    private final DomainResultAssembler keyCollectionAssembler;
    private Object keyContainerValue;
    private Object keyCollectionValue;
    private CollectionKey collectionKey;

    protected AbstractCollectionInitializer(PersistentCollectionDescriptor collectionDescriptor, FetchParentAccess parentAccess, NavigablePath navigablePath, boolean selected, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler) {
        this.collectionDescriptor = collectionDescriptor;
        this.parentAccess = parentAccess;
        this.navigablePath = navigablePath;
        this.selected = selected;
        this.keyTargetAssembler = keyContainerAssembler;
        this.keyCollectionAssembler = keyCollectionAssembler;
    }

    protected PersistentCollectionDescriptor getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    protected boolean isSelected() {
        return this.selected;
    }

    protected FetchParentAccess getParentAccess() {
        return this.parentAccess;
    }

    protected Object getKeyContainerValue() {
        return this.keyContainerValue;
    }

    protected Object getKeyCollectionValue() {
        return this.keyCollectionValue;
    }

    @Override
    public PluralPersistentAttribute getFetchedAttribute() {
        return this.getCollectionDescriptor().getDescribedAttribute();
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        this.keyContainerValue = this.keyTargetAssembler.assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
        this.keyCollectionValue = this.keyCollectionAssembler == null || this.keyTargetAssembler == this.keyCollectionAssembler ? this.keyContainerValue : this.keyCollectionAssembler.assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
        Object keyContainerValue = this.getKeyContainerValue();
        if (keyContainerValue != null) {
            this.collectionKey = new CollectionKey(this.getFetchedAttribute().getPersistentCollectionDescriptor(), keyContainerValue);
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.INSTANCE.debugf("(%s) Current row collection key : %s", StringHelper.collapse(this.getClass().getName()), LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()));
            }
        }
    }

    protected CollectionKey resolveCollectionKey(RowProcessingState rowProcessingState) {
        return this.collectionKey;
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.keyContainerValue = null;
        this.keyCollectionValue = null;
        this.collectionKey = null;
    }
}

