/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.metamodel.model.domain.internal.PersistentBagDescriptorImpl;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.BagInitializer;
import org.hibernate.sql.results.internal.domain.collection.CollectionInitializerProducer;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.CollectionInitializer;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Initializer;

public class BagInitializerProducer
implements CollectionInitializerProducer {
    private final PersistentBagDescriptorImpl bagDescriptor;
    private final boolean selected;
    private final DomainResult collectionIdResult;
    private final DomainResult elementResult;

    public BagInitializerProducer(PersistentBagDescriptorImpl bagDescriptor, boolean selected, DomainResult collectionIdResult, DomainResult elementResult) {
        if (bagDescriptor.getIdDescriptor() != null ? !$assertionsDisabled && collectionIdResult == null : !$assertionsDisabled && collectionIdResult != null) {
            throw new AssertionError();
        }
        this.bagDescriptor = bagDescriptor;
        this.selected = selected;
        this.collectionIdResult = collectionIdResult;
        this.elementResult = elementResult;
    }

    @Override
    public CollectionInitializer produceInitializer(FetchParentAccess parentAccess, NavigablePath navigablePath, LockMode lockMode, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler, Consumer<Initializer> initializerConsumer, AssemblerCreationState creationState) {
        DomainResultAssembler elementAssembler = this.elementResult.createResultAssembler(initializerConsumer, creationState);
        DomainResultAssembler collectionIdAssembler = this.bagDescriptor.getIdDescriptor() == null ? null : this.collectionIdResult.createResultAssembler(initializerConsumer, creationState);
        return new BagInitializer(this.bagDescriptor, parentAccess, navigablePath, this.selected, lockMode, keyContainerAssembler, keyCollectionAssembler, elementAssembler, collectionIdAssembler);
    }
}

