/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.metamodel.model.domain.spi.CollectionKey;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.internal.domain.collection.AbstractCollectionMappingNode;
import org.hibernate.sql.results.internal.domain.collection.CollectionInitializerProducer;
import org.hibernate.sql.results.internal.domain.collection.PluralAttributeAssemblerImpl;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.CollectionFetch;
import org.hibernate.sql.results.spi.CollectionInitializer;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Initializer;

public class CollectionFetchImpl
extends AbstractCollectionMappingNode
implements CollectionFetch {
    private final NavigablePath navigablePath;
    private final LockMode lockMode;
    private final CollectionInitializerProducer initializerProducer;

    public static CollectionFetchImpl create(NavigablePath navigablePath, TableGroup collectionTableGroup, TableGroup containerTableGroup, FetchParent fetchParent, PluralPersistentAttribute describedAttribute, String resultVariable, LockMode lockMode, CollectionInitializerProducer initializerProducer, DomainResultCreationState creationState) {
        DomainResult keyContainerResult;
        DomainResult keyCollectionResult = null;
        if (fetchParent == null) {
            throw new IllegalStateException("FetchParent cannot be null when creating a CollectionFetch");
        }
        if (collectionTableGroup != null) {
            CollectionKey collectionKey = describedAttribute.getPersistentCollectionDescriptor().getCollectionKeyDescriptor();
            keyContainerResult = collectionKey.createContainerResult(containerTableGroup, creationState);
            keyCollectionResult = collectionKey.createCollectionResult(collectionTableGroup, creationState);
        } else {
            keyContainerResult = describedAttribute.getPersistentCollectionDescriptor().getCollectionKeyDescriptor().createContainerResult(containerTableGroup, creationState);
        }
        return new CollectionFetchImpl(navigablePath, fetchParent, describedAttribute, resultVariable, lockMode, keyContainerResult, keyCollectionResult, initializerProducer);
    }

    public CollectionFetchImpl(NavigablePath navigablePath, FetchParent fetchParent, PluralPersistentAttribute describedAttribute, String resultVariable, LockMode lockMode, DomainResult keyContainerResult, DomainResult keyCollectionResult, CollectionInitializerProducer initializerProducer) {
        super(fetchParent, describedAttribute, resultVariable, keyContainerResult, keyCollectionResult);
        this.navigablePath = navigablePath;
        this.lockMode = lockMode;
        this.initializerProducer = initializerProducer;
    }

    @Override
    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, Consumer<Initializer> collector, AssemblerCreationState creationState) {
        DomainResultAssembler keyContainerAssembler = this.getKeyContainerResult().createResultAssembler(collector, creationState);
        DomainResultAssembler keyCollectionAssembler = this.getKeyCollectionResult() == null ? null : this.getKeyCollectionResult().createResultAssembler(collector, creationState);
        CollectionInitializer initializer = this.initializerProducer.produceInitializer(parentAccess, this.getNavigablePath(), this.lockMode, keyContainerAssembler, keyCollectionAssembler, collector, creationState);
        collector.accept(initializer);
        return new PluralAttributeAssemblerImpl(initializer);
    }

    @Override
    public FetchParent getFetchParent() {
        return super.getFetchParent();
    }

    @Override
    public PluralPersistentAttribute getFetchedNavigable() {
        return this.getPluralAttribute();
    }

    @Override
    public boolean isNullable() {
        return true;
    }
}

