/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.AbstractCollectionInitializer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.RowProcessingState;

public class DelayedCollectionInitializer
extends AbstractCollectionInitializer {
    private PersistentCollection collectionInstance;

    public DelayedCollectionInitializer(FetchParentAccess parentAccess, NavigablePath navigablePath, PersistentCollectionDescriptor fetchCollectionDescriptor, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler) {
        super(fetchCollectionDescriptor, parentAccess, navigablePath, false, keyContainerAssembler, keyCollectionAssembler);
    }

    @Override
    public PersistentCollection getCollectionInstance() {
        return this.collectionInstance;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        super.resolveKey(rowProcessingState);
        this.getParentAccess().registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        CollectionKey collectionKey = this.resolveCollectionKey(rowProcessingState);
        if (collectionKey != null) {
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            PersistenceContext persistenceContext = session.getPersistenceContext();
            PersistentCollectionDescriptor collectionDescriptor = this.getFetchedAttribute().getPersistentCollectionDescriptor();
            PersistentCollection existing = persistenceContext.getCollection(collectionKey);
            if (existing != null) {
                this.collectionInstance = existing;
            } else {
                this.collectionInstance = collectionDescriptor.instantiateWrapper(session, collectionKey.getKey());
                this.getParentAccess().registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
                persistenceContext.addUninitializedCollection(collectionDescriptor, this.collectionInstance, collectionKey.getKey());
                if (this.getCollectionDescriptor().getSemantics().getCollectionClassification() == CollectionClassification.ARRAY) {
                    session.getPersistenceContext().addCollectionHolder(this.collectionInstance);
                }
            }
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.collectionInstance = null;
        super.finishUpRow(rowProcessingState);
    }

    public String toString() {
        return "DelayedCollectionInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

