/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.metamodel.model.domain.internal.PersistentMapDescriptorImpl;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.CollectionInitializerProducer;
import org.hibernate.sql.results.internal.domain.collection.MapInitializer;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.CollectionInitializer;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Initializer;

public class MapInitializerProducer
implements CollectionInitializerProducer {
    private final PersistentMapDescriptorImpl mapDescriptor;
    private final boolean isJoined;
    private final DomainResult mapKeyResult;
    private final DomainResult mapValueResult;

    public MapInitializerProducer(PersistentMapDescriptorImpl mapDescriptor, boolean isJoined, DomainResult mapKeyResult, DomainResult mapValueResult) {
        this.mapDescriptor = mapDescriptor;
        this.isJoined = isJoined;
        this.mapKeyResult = mapKeyResult;
        this.mapValueResult = mapValueResult;
    }

    @Override
    public CollectionInitializer produceInitializer(FetchParentAccess parentAccess, NavigablePath navigablePath, LockMode lockMode, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler, Consumer<Initializer> initializerConsumer, AssemblerCreationState creationState) {
        DomainResultAssembler mapKeyAssembler = this.mapKeyResult.createResultAssembler(initializerConsumer, creationState);
        DomainResultAssembler mapValueAssembler = this.mapValueResult.createResultAssembler(initializerConsumer, creationState);
        return new MapInitializer(this.mapDescriptor, parentAccess, navigablePath, this.isJoined, lockMode, keyContainerAssembler, keyCollectionAssembler, mapKeyAssembler, mapValueAssembler);
    }
}

