/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.embedded;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.internal.domain.embedded.CompositeLoadingLogger;
import org.hibernate.sql.results.spi.AbstractFetchParentAccess;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.CompositeInitializer;
import org.hibernate.sql.results.spi.CompositeMappingNode;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public abstract class AbstractCompositeInitializer
extends AbstractFetchParentAccess
implements CompositeInitializer {
    private final EmbeddedTypeDescriptor embeddedTypeDescriptor;
    private final FetchParentAccess fetchParentAccess;
    private final NavigablePath navigablePath;
    private final Map<StateArrayContributor, DomainResultAssembler> assemblerMap = new HashMap<StateArrayContributor, DomainResultAssembler>();
    private Object compositeInstance;
    private Object[] resolvedValues;

    public AbstractCompositeInitializer(CompositeMappingNode resultDescriptor, FetchParentAccess fetchParentAccess, Consumer<Initializer> initializerConsumer, AssemblerCreationState creationState) {
        this.embeddedTypeDescriptor = resultDescriptor.getCompositeNavigableDescriptor().getEmbeddedDescriptor();
        this.fetchParentAccess = fetchParentAccess;
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.embeddedTypeDescriptor.visitStateArrayContributors(stateArrayContributor -> {
            Fetch fetch = resultDescriptor.findFetch(stateArrayContributor.getNavigableName());
            DomainResultAssembler stateAssembler = fetch == null ? new NullValueAssembler((JavaTypeDescriptor)stateArrayContributor.getJavaTypeDescriptor()) : fetch.createAssembler(this, initializerConsumer, creationState);
            this.assemblerMap.put((StateArrayContributor)stateArrayContributor, stateAssembler);
        });
    }

    @Override
    public EmbeddedTypeDescriptor getEmbeddedDescriptor() {
        return this.embeddedTypeDescriptor;
    }

    public FetchParentAccess getFetchParentAccess() {
        return this.fetchParentAccess;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public Object getCompositeInstance() {
        return this.compositeInstance;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        PersistentAttributeDescriptor parentInjectionTarget = null;
        if (parentInjectionTarget != null) {
            this.getFetchParentAccess().findFirstEntityDescriptorAccess().registerResolutionListener(owner -> {
                if (this.compositeInstance == null) {
                    return;
                }
                parentInjectionTarget.getPropertyAccess().getSetter().set(this.compositeInstance, owner, rowProcessingState.getSession().getFactory());
            });
        }
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        this.compositeInstance = this.getEmbeddedDescriptor().instantiate(rowProcessingState.getSession());
        CompositeLoadingLogger.INSTANCE.debugf("Created composite instance [%s] : %s", LoggingHelper.toLoggableString(this.navigablePath), this.compositeInstance);
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        CompositeLoadingLogger.INSTANCE.debugf("Initializing composite instance [%s] : %s", LoggingHelper.toLoggableString(this.navigablePath), this.compositeInstance);
        this.resolvedValues = new Object[this.assemblerMap.size()];
        for (Map.Entry<StateArrayContributor, DomainResultAssembler> entry : this.assemblerMap.entrySet()) {
            Object contributorValue;
            this.resolvedValues[entry.getKey().getStateArrayPosition()] = contributorValue = entry.getValue().assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
        }
        this.getEmbeddedDescriptor().setPropertyValues(this.compositeInstance, this.resolvedValues);
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.compositeInstance = null;
        this.resolvedValues = null;
        this.clearParentResolutionListeners();
    }

    @Override
    public FetchParentAccess findFirstEntityDescriptorAccess() {
        return this.getFetchParentAccess().findFirstEntityDescriptorAccess();
    }
}

