/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.embedded;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.model.domain.spi.EmbeddedValuedNavigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.AbstractFetchParent;
import org.hibernate.sql.results.internal.domain.embedded.CompositeLoadingLogger;
import org.hibernate.sql.results.internal.domain.embedded.CompositeRootInitializerImpl;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.CompositeInitializer;
import org.hibernate.sql.results.spi.CompositeMappingNode;
import org.hibernate.sql.results.spi.CompositeResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.EmbeddableJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class CompositeForeignKeyResultImpl
extends AbstractFetchParent
implements CompositeResult {
    private final List<SqlSelection> sqlSelections;

    public CompositeForeignKeyResultImpl(EmbeddedValuedNavigable navigable, List<SqlSelection> sqlSelections) {
        super(navigable, new NavigablePath(navigable.getEmbeddedDescriptor().getRoleName()));
        this.sqlSelections = sqlSelections;
    }

    @Override
    public DomainResultAssembler createResultAssembler(Consumer<Initializer> initializerCollector, AssemblerCreationState creationOptions) {
        CompositeForeignKeyInitializerImpl initializer = new CompositeForeignKeyInitializerImpl(null, this, initializerCollector, creationOptions);
        return new CompositeForeignKeyAssembler(initializer);
    }

    @Override
    public String getResultVariable() {
        return null;
    }

    @Override
    public EmbeddableJavaDescriptor getJavaTypeDescriptor() {
        return this.getCompositeNavigableDescriptor().getJavaTypeDescriptor();
    }

    @Override
    public EmbeddedValuedNavigable getCompositeNavigableDescriptor() {
        return (EmbeddedValuedNavigable)super.getNavigableContainer();
    }

    @Override
    protected void afterInitialize(DomainResultCreationState creationState) {
    }

    public class CompositeForeignKeyInitializerImpl
    extends CompositeRootInitializerImpl {
        public CompositeForeignKeyInitializerImpl(FetchParentAccess fetchParentAccess, CompositeMappingNode resultDescriptor, Consumer<Initializer> initializerConsumer, AssemblerCreationState creationOptions) {
            super(fetchParentAccess, resultDescriptor, initializerConsumer, creationOptions);
        }

        @Override
        public void initializeInstance(RowProcessingState rowProcessingState) {
            CompositeLoadingLogger.INSTANCE.debugf("Initializing composite instance [%s] : %s", LoggingHelper.toLoggableString(this.getNavigablePath()), this.getCompositeInstance());
            int size = CompositeForeignKeyResultImpl.this.sqlSelections.size();
            Object[] result = new Object[size];
            for (int i = 0; i < size; ++i) {
                result[i] = rowProcessingState.getJdbcValue((SqlSelection)CompositeForeignKeyResultImpl.this.sqlSelections.get(i));
            }
            this.getEmbeddedDescriptor().setPropertyValues(this.getCompositeInstance(), result);
        }
    }

    public class CompositeForeignKeyAssembler
    implements DomainResultAssembler {
        private final CompositeInitializer initializer;

        public CompositeForeignKeyAssembler(CompositeInitializer initializer) {
            this.initializer = initializer;
        }

        @Override
        public JavaTypeDescriptor getJavaTypeDescriptor() {
            return this.initializer.getEmbeddedDescriptor().getJavaTypeDescriptor();
        }

        @Override
        public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            this.initializer.resolveKey(rowProcessingState);
            this.initializer.resolveInstance(rowProcessingState);
            this.initializer.initializeInstance(rowProcessingState);
            return this.initializer.getCompositeInstance();
        }
    }
}

