/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.WrongClassException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.internal.domain.entity.EntityLoadingLogger;
import org.hibernate.sql.results.internal.domain.entity.ManagedTypeSubInitializerConsumer;
import org.hibernate.sql.results.spi.AbstractFetchParentAccess;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.EntityInitializer;
import org.hibernate.sql.results.spi.EntityMappingNode;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.LoadingEntityEntry;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.internal.TypeHelper;

public abstract class AbstractEntityInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final EntityTypeDescriptor<?> entityDescriptor;
    private final NavigablePath navigablePath;
    private final LockMode lockMode;
    private final List<Initializer> identifierInitializers = new ArrayList<Initializer>();
    private final DomainResultAssembler identifierAssembler;
    private final DomainResultAssembler discriminatorAssembler;
    private final DomainResultAssembler versionAssembler;
    private final Map<StateArrayContributor, DomainResultAssembler> assemblerMap = new HashMap<StateArrayContributor, DomainResultAssembler>();
    private EntityTypeDescriptor<?> concreteDescriptor;
    private EntityKey entityKey;
    private Object entityInstance;
    private boolean missing;
    private Object[] resolvedEntityState;

    protected AbstractEntityInitializer(EntityMappingNode resultDescriptor, NavigablePath navigablePath, LockMode lockMode, DomainResult identifierResult, DomainResult discriminatorResult, DomainResult versionResult, Consumer<Initializer> initializerConsumer, AssemblerCreationState creationState) {
        this.entityDescriptor = resultDescriptor.getEntityValuedNavigable().getEntityDescriptor();
        this.navigablePath = navigablePath;
        this.lockMode = lockMode;
        this.identifierAssembler = identifierResult.createResultAssembler(this.identifierInitializers::add, creationState);
        if (this.entityDescriptor.getHierarchy().getDiscriminatorDescriptor() != null) {
            assert (discriminatorResult != null);
            this.discriminatorAssembler = discriminatorResult.createResultAssembler(initializer -> {
                throw new UnsupportedOperationException("Registering an Initializer as part of Entity discriminator is illegal");
            }, creationState);
        } else {
            this.discriminatorAssembler = null;
        }
        if (this.entityDescriptor.getHierarchy().getVersionDescriptor() != null) {
            assert (versionResult != null);
            this.versionAssembler = versionResult.createResultAssembler(initializer -> {
                throw new UnsupportedOperationException("Registering an Initializer as part of Entity version is illegal");
            }, creationState);
        } else {
            this.versionAssembler = null;
        }
        ManagedTypeSubInitializerConsumer subInitializerConsumer = new ManagedTypeSubInitializerConsumer(initializerConsumer);
        this.entityDescriptor.visitStateArrayContributors(stateArrayContributor -> {
            Fetch fetch = resultDescriptor.findFetch(stateArrayContributor.getNavigableName());
            DomainResultAssembler stateAssembler = fetch == null ? new NullValueAssembler((JavaTypeDescriptor)stateArrayContributor.getJavaTypeDescriptor()) : fetch.createAssembler(this, subInitializerConsumer, creationState);
            this.assemblerMap.put((StateArrayContributor)stateArrayContributor, stateAssembler);
        });
        initializerConsumer.accept(this);
        subInitializerConsumer.finishUp();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    protected abstract boolean isEntityReturn();

    @Override
    public EntityTypeDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    public Object getKeyValue() {
        return this.entityKey.getIdentifier();
    }

    @Override
    public Object getFetchParentInstance() {
        if (this.entityInstance == null) {
            throw new IllegalStateException("Unexpected state condition - entity instance not yet resolved");
        }
        return this.entityInstance;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.entityInstance != null) {
            return;
        }
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.INSTANCE.tracef("(%s) Beginning Initializer#resolveKey process for entity : %s", StringHelper.collapse(this.getClass().getName()), LoggingHelper.toLoggableString(this.getNavigablePath()));
        }
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        this.concreteDescriptor = this.determineConcreteEntityDescriptor(rowProcessingState, session);
        this.initializeIdentifier(rowProcessingState);
        this.resolveEntityKey(rowProcessingState);
        if (this.entityKey == null) {
            EntityLoadingLogger.INSTANCE.debugf("(%s) EntityKey (%s) is null", StringHelper.collapse(this.getClass().getName()), LoggingHelper.toLoggableString(this.getNavigablePath()));
            assert (this.missing);
            return;
        }
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.INSTANCE.debugf("(%s) Hydrated EntityKey (%s): %s", StringHelper.collapse(this.getClass().getName()), LoggingHelper.toLoggableString(this.getNavigablePath()), this.entityKey.getIdentifier());
        }
    }

    private EntityTypeDescriptor determineConcreteEntityDescriptor(RowProcessingState rowProcessingState, SharedSessionContractImplementor persistenceContext) throws WrongClassException {
        if (this.discriminatorAssembler == null) {
            return this.entityDescriptor;
        }
        Object discriminatorValue = this.discriminatorAssembler.assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
        String result = this.entityDescriptor.getHierarchy().getDiscriminatorDescriptor().getDiscriminatorMappings().discriminatorValueToEntityName(discriminatorValue);
        if (result == null) {
            throw new WrongClassException("Discriminator: " + discriminatorValue, this.entityKey.getIdentifier(), this.entityDescriptor.getEntityName());
        }
        return persistenceContext.getFactory().getMetamodel().findEntityDescriptor(result);
    }

    protected void initializeIdentifier(RowProcessingState rowProcessingState) {
        this.identifierInitializers.forEach(initializer -> initializer.resolveKey(rowProcessingState));
        this.identifierInitializers.forEach(initializer -> initializer.resolveInstance(rowProcessingState));
        this.identifierInitializers.forEach(initializer -> initializer.initializeInstance(rowProcessingState));
    }

    protected void resolveEntityKey(RowProcessingState rowProcessingState) {
        if (this.entityKey != null) {
            return;
        }
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        Object id = this.identifierAssembler.assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
        if (id == null) {
            this.missing = true;
            return;
        }
        this.entityKey = new EntityKey(id, this.concreteDescriptor.getEntityDescriptor());
        if (this.concreteDescriptor.getEntityDescriptor().isBatchLoadable() && !session.getPersistenceContext().containsEntity(this.entityKey)) {
            session.getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(this.entityKey);
        }
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        Object entity;
        Serializable requestedEntityId;
        SharedSessionContractImplementor session;
        LoadingEntityEntry existingLoadingEntry;
        if (this.missing) {
            return;
        }
        Object entityIdentifier = this.entityKey.getIdentifier();
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.INSTANCE.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", StringHelper.collapse(this.getClass().getName()), LoggingHelper.toLoggableString(this.getNavigablePath()), entityIdentifier);
        }
        if ((existingLoadingEntry = (session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession()).getPersistenceContext().getLoadContexts().findLoadingEntityEntry(this.entityKey)) != null) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.INSTANCE.debugf("(%s) Found existing loading entry [%s] - using loading instance", StringHelper.collapse(this.getClass().getName()), LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
            }
            this.entityInstance = existingLoadingEntry.getEntityInstance();
            if (existingLoadingEntry.getEntityInitializer() != this) {
                if (EntityLoadingLogger.DEBUG_ENABLED) {
                    EntityLoadingLogger.INSTANCE.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", StringHelper.collapse(this.getClass().getName()), LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), existingLoadingEntry.getEntityInitializer());
                }
                return;
            }
        }
        if (this.entityInstance == null && this.isEntityReturn() && (requestedEntityId = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalId()) != null && requestedEntityId.equals(this.entityKey.getIdentifier())) {
            this.entityInstance = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalObject();
        }
        if (this.entityInstance == null && (entity = session.getPersistenceContext().getEntity(this.entityKey)) != null) {
            this.entityInstance = entity;
        }
        if (this.entityInstance == null) {
            this.entityInstance = session.instantiate(this.concreteDescriptor.getEntityName(), this.entityKey.getIdentifier());
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.INSTANCE.debugf("Created new entity instance [%s] : %s", LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), this.entityInstance);
            }
            LoadingEntityEntry loadingEntry = new LoadingEntityEntry(this, this.entityKey, this.concreteDescriptor, this.entityInstance);
            rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingEntity(this.entityKey, loadingEntry);
        }
        this.notifyParentResolutionListeners(this.entityInstance);
        this.preLoad(rowProcessingState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        Status status;
        SharedSessionContractImplementor session;
        PersistenceContext persistenceContext;
        if (this.missing) {
            return;
        }
        Object entityIdentifier = this.entityKey.getIdentifier();
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.INSTANCE.tracef("Beginning Initializer#initializeInstance process for entity %s", LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        if ((persistenceContext = (session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession()).getPersistenceContext()).containsEntity(this.entityKey) && ((status = persistenceContext.getEntry(persistenceContext.getEntity(this.entityKey)).getStatus()) == Status.DELETED || status == Status.GONE)) {
            return;
        }
        Object rowId = null;
        this.entityDescriptor.setIdentifier(this.entityInstance, entityIdentifier, session);
        this.resolvedEntityState = new Object[this.assemblerMap.size()];
        this.assemblerMap.forEach((key, value) -> {
            this.resolvedEntityState[key.getStateArrayPosition()] = value.assemble(rowProcessingState);
        });
        this.entityDescriptor.setPropertyValues(this.entityInstance, this.resolvedEntityState);
        persistenceContext.addEntity(this.entityKey, this.entityInstance);
        Object version = this.versionAssembler != null ? this.versionAssembler.assemble(rowProcessingState) : null;
        EntityEntry entityEntry = persistenceContext.addEntry(this.entityInstance, Status.LOADING, this.resolvedEntityState, rowId, this.entityKey.getIdentifier(), version, this.lockMode, true, this.entityDescriptor, false);
        SessionFactoryImplementor factory = session.getFactory();
        EntityDataAccess cacheAccess = this.entityDescriptor.getHierarchy().getEntityCacheAccess();
        if (cacheAccess != null && session.getCacheMode().isPutEnabled()) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.INSTANCE.debugf("Adding entityInstance to second-level cache: %s", LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
            }
            CacheEntry entry = this.entityDescriptor.buildCacheEntry(this.entityInstance, this.resolvedEntityState, version, session);
            Object cacheKey = cacheAccess.generateCacheKey(entityIdentifier, this.entityDescriptor.getHierarchy(), factory, session.getTenantIdentifier());
            if (persistenceContext.wasInsertedDuringTransaction(this.entityDescriptor, entityIdentifier)) {
                cacheAccess.update(session, cacheKey, this.entityDescriptor.getCacheEntryStructure().structure(entry), version, version);
            } else {
                SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
                try {
                    eventListenerManager.cachePutStart();
                    boolean put = cacheAccess.putFromLoad(session, cacheKey, this.entityDescriptor.getCacheEntryStructure().structure(entry), version, false);
                    if (put && factory.getStatistics().isStatisticsEnabled()) {
                        factory.getStatistics().entityCachePut(this.entityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                    }
                }
                finally {
                    eventListenerManager.cachePutEnd();
                }
            }
        }
        if (this.entityDescriptor.getHierarchy().getNaturalIdDescriptor() != null) {
            persistenceContext.getNaturalIdHelper().cacheNaturalIdCrossReferenceFromLoad(this.entityDescriptor, entityIdentifier, persistenceContext.getNaturalIdHelper().extractNaturalIdValues(this.resolvedEntityState, this.entityDescriptor));
        }
        boolean isReallyReadOnly = this.isReadOnly(rowProcessingState, session);
        if (!this.entityDescriptor.getHierarchy().getMutabilityPlan().isMutable()) {
            isReallyReadOnly = true;
        } else {
            Object proxy = persistenceContext.getProxy(this.entityKey);
            if (proxy != null) {
                isReallyReadOnly = ((HibernateProxy)proxy).getHibernateLazyInitializer().isReadOnly();
            }
        }
        if (isReallyReadOnly) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            TypeHelper.deepCopy(this.entityDescriptor, this.resolvedEntityState, this.resolvedEntityState, StateArrayContributor::isUpdatable);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
        this.entityDescriptor.afterInitialize(this.entityInstance, session);
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.INSTANCE.debugf("Done materializing entityInstance : %s", LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatistics().loadEntity(this.entityDescriptor.getEntityName());
        }
        this.postLoad(rowProcessingState);
    }

    private boolean isReadOnly(RowProcessingState rowProcessingState, SharedSessionContractImplementor persistenceContext) {
        if (persistenceContext.isDefaultReadOnly()) {
            return true;
        }
        Boolean queryOption = rowProcessingState.getJdbcValuesSourceProcessingState().getQueryOptions().isReadOnly();
        return queryOption == null ? false : queryOption;
    }

    private void preLoad(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        PreLoadEvent preLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPreLoadEvent();
        preLoadEvent.reset();
        if (session.isEventSource()) {
            preLoadEvent.setEntity(this.entityInstance).setId(this.entityKey.getIdentifier()).setDescriptor(this.entityDescriptor);
            EventListenerGroup<PreLoadEventListener> listenerGroup = session.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.PRE_LOAD);
            for (PreLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPreLoad(preLoadEvent);
            }
        }
    }

    private void postLoad(RowProcessingState rowProcessingState) {
        PostLoadEvent postLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPostLoadEvent();
        postLoadEvent.reset();
        postLoadEvent.setEntity(this.entityInstance).setId(this.entityKey.getIdentifier()).setDescriptor(this.concreteDescriptor);
        EventListenerGroup<PostLoadEventListener> listenerGroup = this.entityDescriptor.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.POST_LOAD);
        for (PostLoadEventListener listener : listenerGroup.listeners()) {
            listener.onPostLoad(postLoadEvent);
        }
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.concreteDescriptor = null;
        this.entityKey = null;
        this.entityInstance = null;
        this.missing = false;
        this.resolvedEntityState = null;
        this.clearParentResolutionListeners();
    }
}

