/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import org.hibernate.LockMode;
import org.hibernate.metamodel.model.domain.spi.DiscriminatorDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.AbstractFetchParent;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.EntityMappingNode;
import org.hibernate.type.descriptor.java.spi.EntityJavaDescriptor;

public abstract class AbstractEntityMappingNode
extends AbstractFetchParent
implements EntityMappingNode {
    private final EntityValuedNavigable entityValuedNavigable;
    private final DomainResult identifierResult;
    private final DomainResult discriminatorResult;
    private final DomainResult versionResult;
    private final LockMode lockMode;

    public AbstractEntityMappingNode(EntityValuedNavigable entityValuedNavigable, LockMode lockMode, NavigablePath navigablePath, DomainResultCreationState creationState) {
        super(entityValuedNavigable, navigablePath);
        this.entityValuedNavigable = entityValuedNavigable;
        this.lockMode = lockMode;
        EntityTypeDescriptor entityDescriptor = entityValuedNavigable.getEntityDescriptor();
        this.identifierResult = entityDescriptor.getIdentifierDescriptor().createDomainResult(navigablePath.append("{id}"), null, creationState);
        DiscriminatorDescriptor discriminatorDescriptor = entityDescriptor.getHierarchy().getDiscriminatorDescriptor();
        this.discriminatorResult = discriminatorDescriptor == null ? null : discriminatorDescriptor.createDomainResult(navigablePath.append("{type}"), null, creationState);
        VersionDescriptor versionDescriptor = entityDescriptor.getHierarchy().getVersionDescriptor();
        this.versionResult = versionDescriptor == null ? null : versionDescriptor.createDomainResult(navigablePath.append(versionDescriptor.getNavigableName()), null, creationState);
    }

    @Override
    public EntityValuedNavigable getEntityValuedNavigable() {
        return this.entityValuedNavigable;
    }

    @Override
    public EntityJavaDescriptor getJavaTypeDescriptor() {
        return this.getEntityValuedNavigable().getJavaTypeDescriptor();
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    protected DomainResult getIdentifierResult() {
        return this.identifierResult;
    }

    protected DomainResult getDiscriminatorResult() {
        return this.discriminatorResult;
    }

    protected DomainResult getVersionResult() {
        return this.versionResult;
    }
}

