/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import java.util.Locale;
import javax.persistence.EntityNotFoundException;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.loader.spi.SingleEntityLoader;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.entity.EntityLoadingLogger;
import org.hibernate.sql.results.spi.AbstractFetchParentAccess;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.EntityInitializer;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowProcessingState;

public abstract class AbstractImmediateEntityFetchInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final EntityValuedNavigable fetchedNavigable;
    private final NavigablePath navigablePath;
    private final SingleEntityLoader loader;
    private final FetchParentAccess parentAccess;
    private final DomainResultAssembler keyValueAssembler;
    private final NotFoundAction notFoundAction;
    private boolean keyHydrated;
    private Object keyValue;
    private Object entityInstance;

    protected AbstractImmediateEntityFetchInitializer(EntityValuedNavigable fetchedNavigable, NavigablePath navigablePath, SingleEntityLoader loader, FetchParentAccess parentAccess, DomainResultAssembler keyValueAssembler, NotFoundAction notFoundAction) {
        this.fetchedNavigable = fetchedNavigable;
        this.navigablePath = navigablePath;
        this.loader = loader;
        this.parentAccess = parentAccess;
        this.keyValueAssembler = keyValueAssembler;
        this.notFoundAction = notFoundAction;
    }

    @Override
    public EntityTypeDescriptor getEntityDescriptor() {
        return this.fetchedNavigable.getEntityDescriptor();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    public EntityValuedNavigable getFetchedNavigable() {
        return this.fetchedNavigable;
    }

    public FetchParentAccess getParentAccess() {
        return this.parentAccess;
    }

    protected Object getKeyValue() {
        return this.keyValue;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    protected void setEntityInstance(Object entityInstance) {
        assert (this.entityInstance == null);
        this.entityInstance = entityInstance;
    }

    protected abstract boolean isLoadingEntityInstance();

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.keyHydrated) {
            return;
        }
        JdbcValuesSourceProcessingOptions processingOptions = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions();
        this.keyValue = this.keyValueAssembler.assemble(rowProcessingState, processingOptions);
        this.keyHydrated = true;
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.INSTANCE.debugf("Hydrated fetched entity key : %s", LoggingHelper.toLoggableString(this.getNavigablePath(), this.keyValue));
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (!this.isLoadingEntityInstance()) {
            return;
        }
        if (this.entityInstance != null) {
            return;
        }
        if (this.getKeyValue() == null) {
            return;
        }
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        this.entityInstance = this.loader.load(this.getKeyValue(), rowProcessingState.getQueryOptions().getLockOptions(), session);
        if (this.entityInstance == null) {
            if (this.notFoundAction == NotFoundAction.EXCEPTION) {
                throw new EntityNotFoundException("Unable to locate entity by key - " + this.loader.getLoadedNavigable().getNavigableName() + "#" + this.getKeyValue());
            }
        } else {
            this.afterLoad(this.entityInstance, rowProcessingState);
        }
    }

    protected abstract void afterLoad(Object var1, RowProcessingState var2);

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.keyHydrated = false;
        this.keyValue = null;
        this.entityInstance = null;
        this.clearParentResolutionListeners();
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(%s - %s) - current state : keyValue=%s, entityInstance=%s", this.getClass().getSimpleName(), this.getFetchedNavigable().getNavigableRole().getFullPath(), this.keyType().name(), this.keyValue, this.entityInstance);
    }

    protected abstract KeyType keyType();

    protected static enum KeyType {
        PK,
        UK;

    }
}

