/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.sql.results.internal.domain.entity.DelayedEntityFetchInitializer;
import org.hibernate.sql.results.internal.domain.entity.EntityAssembler;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.EntityFetch;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class DelayedEntityFetch
implements EntityFetch {
    private final FetchParent fetchParent;
    private final EntityValuedNavigable fetchedNavigable;
    private final DomainResult fkResult;

    public DelayedEntityFetch(FetchParent fetchParent, EntityValuedNavigable fetchedNavigable, DomainResult fkResult) {
        this.fetchParent = fetchParent;
        this.fetchedNavigable = fetchedNavigable;
        this.fkResult = fkResult;
    }

    @Override
    public EntityValuedNavigable getEntityValuedNavigable() {
        return this.fetchedNavigable;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public EntityValuedNavigable getFetchedNavigable() {
        return this.fetchedNavigable;
    }

    @Override
    public boolean isNullable() {
        return this.fetchedNavigable.isNullable();
    }

    @Override
    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, Consumer<Initializer> collector, AssemblerCreationState creationState) {
        DelayedEntityFetchInitializer initializer = new DelayedEntityFetchInitializer(this.fetchedNavigable, parentAccess, this.fkResult.createResultAssembler(collector, creationState));
        collector.accept(initializer);
        return new EntityAssembler(this.getFetchedNavigable().getJavaTypeDescriptor(), initializer);
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getFetchedNavigable().getJavaTypeDescriptor();
    }

    @Override
    public NavigableContainer getNavigableContainer() {
        return this.fetchedNavigable.getContainer();
    }

    @Override
    public List<Fetch> getFetches() {
        return Collections.emptyList();
    }
}

