/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import java.util.function.Consumer;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.spi.AbstractFetchParentAccess;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.EntityInitializer;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.RowProcessingState;

public class DelayedEntityFetchInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final EntityValuedNavigable fetchedNavigable;
    private final FetchParentAccess parentAccess;
    private final DomainResultAssembler fkValueAssembler;
    private final NavigablePath path;
    private Object entityInstance;
    private Object fkValue;

    protected DelayedEntityFetchInitializer(EntityValuedNavigable fetchedNavigable, FetchParentAccess parentAccess, DomainResultAssembler fkValueAssembler) {
        this.fetchedNavigable = fetchedNavigable;
        this.parentAccess = parentAccess;
        this.fkValueAssembler = fkValueAssembler;
        this.path = parentAccess.getNavigablePath().append(fetchedNavigable.getNavigableName());
    }

    @Override
    public EntityTypeDescriptor getEntityDescriptor() {
        return this.fetchedNavigable.getEntityDescriptor();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.path;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstance != null) {
            listener.accept(this.entityInstance);
        } else {
            super.registerResolutionListener(listener);
        }
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        this.fkValue = this.fkValueAssembler.assemble(rowProcessingState);
        if (this.fkValue == null) {
            this.entityInstance = null;
        } else {
            if (this.fetchedNavigable.getEntityDescriptor().hasProxy()) {
                this.entityInstance = this.fetchedNavigable.getEntityDescriptor().createProxy(this.fkValue, rowProcessingState.getSession());
            } else if (this.fetchedNavigable.getEntityDescriptor().getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
                this.entityInstance = this.fetchedNavigable.getEntityDescriptor().instantiate(this.fkValue, rowProcessingState.getSession());
            }
            this.notifyParentResolutionListeners(this.entityInstance);
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.fkValue = null;
        this.entityInstance = null;
        this.clearParentResolutionListeners();
    }
}

