/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import java.util.function.Consumer;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.entity.AbstractEntityMappingNode;
import org.hibernate.sql.results.internal.domain.entity.EntityAssembler;
import org.hibernate.sql.results.internal.domain.entity.EntityRootInitializer;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.EntityResult;
import org.hibernate.sql.results.spi.Initializer;

public class EntityResultImpl
extends AbstractEntityMappingNode
implements EntityResult {
    private final String resultVariable;

    public EntityResultImpl(NavigablePath navigablePath, EntityValuedNavigable referencedEntity, String resultVariable, DomainResultCreationState creationState) {
        super(referencedEntity, creationState.determineLockMode(resultVariable), navigablePath, creationState);
        this.resultVariable = resultVariable;
        this.afterInitialize(creationState);
    }

    public EntityValuedNavigable getNavigable() {
        return this.getEntityValuedNavigable();
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public DomainResultAssembler createResultAssembler(Consumer<Initializer> collector, AssemblerCreationState creationState) {
        EntityRootInitializer initializer = new EntityRootInitializer(this, this.getNavigablePath(), this.getLockMode(), this.getIdentifierResult(), this.getDiscriminatorResult(), this.getVersionResult(), collector, creationState);
        return new EntityAssembler(this.getNavigable().getJavaTypeDescriptor(), initializer);
    }
}

