/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.spi.SingleEntityLoader;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.entity.AbstractImmediateEntityFetchInitializer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.LoadingEntityEntry;
import org.hibernate.sql.results.spi.RowProcessingState;

public class ImmediatePkEntityFetchInitializer
extends AbstractImmediateEntityFetchInitializer {
    private EntityKey entityKey;
    private boolean isLoadingEntity;

    public ImmediatePkEntityFetchInitializer(EntityValuedNavigable fetchedNavigable, NavigablePath navigablePath, SingleEntityLoader loader, FetchParentAccess parentAccess, DomainResultAssembler keyValueAssembler, NotFoundAction notFoundAction) {
        super(fetchedNavigable, navigablePath, loader, parentAccess, keyValueAssembler, notFoundAction);
    }

    @Override
    protected AbstractImmediateEntityFetchInitializer.KeyType keyType() {
        return AbstractImmediateEntityFetchInitializer.KeyType.PK;
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.entityKey != null) {
            return;
        }
        Object keyValue = this.getKeyValue();
        if (keyValue == null) {
            return;
        }
        this.entityKey = new EntityKey(keyValue, this.getEntityDescriptor());
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        LoadingEntityEntry existingEntry = session.getPersistenceContext().getLoadContexts().findLoadingEntityEntry(this.entityKey);
        if (existingEntry != null) {
            this.setEntityInstance(existingEntry.getEntityInstance());
            this.isLoadingEntity = false;
            return;
        }
        Object managed = session.getPersistenceContext().getEntity(this.entityKey);
        if (managed != null) {
            this.setEntityInstance(managed);
            this.isLoadingEntity = false;
            return;
        }
        Object entityInstance = this.getEntityDescriptor().instantiate(keyValue, session);
        LoadingEntityEntry entityEntry = new LoadingEntityEntry(this, this.entityKey, this.getEntityDescriptor(), entityInstance);
        rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingEntity(this.entityKey, entityEntry);
        this.isLoadingEntity = true;
    }

    @Override
    protected boolean isLoadingEntityInstance() {
        return this.isLoadingEntity;
    }

    @Override
    protected void afterLoad(Object entityInstance, RowProcessingState rowProcessingState) {
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        super.finishUpRow(rowProcessingState);
        this.entityKey = null;
        this.isLoadingEntity = false;
    }
}

