/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.entity;

import java.util.function.BiFunction;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.loader.spi.SingleEntityLoader;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.entity.AbstractImmediateEntityFetchInitializer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.RowProcessingState;

public class ImmediateUkEntityFetchInitializer
extends AbstractImmediateEntityFetchInitializer {
    private final BiFunction<Object, SharedSessionContractImplementor, EntityUniqueKey> uniqueKeyGenerator;
    private EntityUniqueKey entityKey;
    private boolean isLoadingEntity;

    public ImmediateUkEntityFetchInitializer(EntityValuedNavigable fetchedNavigable, NavigablePath navigablePath, SingleEntityLoader loader, FetchParentAccess parentAccess, DomainResultAssembler keyValueAssembler, NotFoundAction notFoundAction, BiFunction<Object, SharedSessionContractImplementor, EntityUniqueKey> uniqueKeyGenerator) {
        super(fetchedNavigable, navigablePath, loader, parentAccess, keyValueAssembler, notFoundAction);
        this.uniqueKeyGenerator = uniqueKeyGenerator;
    }

    @Override
    protected AbstractImmediateEntityFetchInitializer.KeyType keyType() {
        return AbstractImmediateEntityFetchInitializer.KeyType.UK;
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.entityKey != null) {
            return;
        }
        Object keyValue = this.getKeyValue();
        if (keyValue == null) {
            return;
        }
        this.entityKey = this.uniqueKeyGenerator.apply(keyValue, rowProcessingState.getSession());
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        Object managed = session.getPersistenceContext().getEntity(this.entityKey);
        if (managed != null) {
            this.setEntityInstance(managed);
            this.isLoadingEntity = false;
            return;
        }
        this.isLoadingEntity = true;
    }

    @Override
    protected boolean isLoadingEntityInstance() {
        return this.isLoadingEntity;
    }

    @Override
    protected void afterLoad(Object entityInstance, RowProcessingState rowProcessingState) {
        if (entityInstance != null) {
            rowProcessingState.getSession().getPersistenceContext().addEntity(this.entityKey, entityInstance);
        }
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        super.finishUpRow(rowProcessingState);
        this.entityKey = null;
        this.isLoadingEntity = false;
    }

    @Override
    public String toString() {
        return "ImmediateUkEntityFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

