/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.hibernate.sql.results.internal.instantiation.ArgumentReader;
import org.hibernate.sql.results.internal.instantiation.InstantiationException;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class DynamicInstantiationConstructorAssemblerImpl
implements DomainResultAssembler {
    private final Constructor targetConstructor;
    private final JavaTypeDescriptor resultType;
    private final List<ArgumentReader> argumentReaders;

    public DynamicInstantiationConstructorAssemblerImpl(Constructor targetConstructor, JavaTypeDescriptor resultType, List<ArgumentReader> argumentReaders) {
        this.targetConstructor = targetConstructor;
        this.resultType = resultType;
        this.argumentReaders = argumentReaders;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.resultType;
    }

    @Override
    public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        int numberOfArgs = this.argumentReaders.size();
        Object[] args = new Object[numberOfArgs];
        for (int i = 0; i < numberOfArgs; ++i) {
            args[i] = this.argumentReaders.get(i).assemble(rowProcessingState, options);
        }
        try {
            return this.targetConstructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw new InstantiationException("Error performing dynamic instantiation : " + this.targetConstructor.getDeclaringClass().getName(), e.getCause());
        }
        catch (Exception e) {
            throw new InstantiationException("Error performing dynamic instantiation : " + this.targetConstructor.getDeclaringClass().getName(), e);
        }
    }
}

