/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.instantiation;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.util.beans.BeanInfoHelper;
import org.hibernate.query.sqm.tree.expression.Compatibility;
import org.hibernate.sql.results.internal.instantiation.ArgumentReader;
import org.hibernate.sql.results.internal.instantiation.BeanInjection;
import org.hibernate.sql.results.internal.instantiation.BeanInjectorField;
import org.hibernate.sql.results.internal.instantiation.BeanInjectorSetter;
import org.hibernate.sql.results.internal.instantiation.InstantiationException;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class DynamicInstantiationInjectionAssemblerImpl
implements DomainResultAssembler {
    private final JavaTypeDescriptor target;
    private final List<BeanInjection> beanInjections = new ArrayList<BeanInjection>();

    public DynamicInstantiationInjectionAssemblerImpl(JavaTypeDescriptor target, List<ArgumentReader> argumentReaders) {
        this.target = target;
        Class targetJavaType = target.getJavaType();
        BeanInfoHelper.visitBeanInfo(targetJavaType, beanInfo -> {
            for (ArgumentReader argumentReader : argumentReaders) {
                boolean found = false;
                for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                    boolean assignmentCompatible;
                    if (!argumentReader.getAlias().equals(propertyDescriptor.getName()) || propertyDescriptor.getWriteMethod() == null || !(assignmentCompatible = Compatibility.areAssignmentCompatible(propertyDescriptor.getWriteMethod().getParameterTypes()[0], argumentReader.getJavaTypeDescriptor().getClass()))) continue;
                    propertyDescriptor.getWriteMethod().setAccessible(true);
                    this.beanInjections.add(new BeanInjection(new BeanInjectorSetter(propertyDescriptor.getWriteMethod()), argumentReader));
                    found = true;
                    break;
                }
                if (found) continue;
                Field field = this.findField(targetJavaType, argumentReader.getAlias(), argumentReader.getJavaTypeDescriptor().getJavaType());
                if (field != null) {
                    this.beanInjections.add(new BeanInjection(new BeanInjectorField(field), argumentReader));
                    continue;
                }
                throw new InstantiationException("Unable to determine dynamic instantiation injection strategy for " + targetJavaType.getName() + "#" + argumentReader.getAlias());
            }
        });
        if (argumentReaders.size() != this.beanInjections.size()) {
            throw new IllegalStateException("The number of readers did not match the number of injections");
        }
    }

    private Field findField(Class declaringClass, String name, Class javaType) {
        try {
            Field field = declaringClass.getDeclaredField(name);
            if (Compatibility.areAssignmentCompatible(field.getType(), javaType)) {
                field.setAccessible(true);
                return field;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.target;
    }

    @Override
    public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        try {
            Object result = this.target.getJavaType().newInstance();
            for (BeanInjection beanInjection : this.beanInjections) {
                beanInjection.getBeanInjector().inject(result, beanInjection.getValueAssembler().assemble(rowProcessingState, options));
            }
            return result;
        }
        catch (IllegalAccessException | java.lang.InstantiationException e) {
            throw new InstantiationException("Could not call default constructor [" + this.target.getJavaType().getSimpleName() + "]", e);
        }
    }
}

