/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.instantiation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.sql.results.internal.instantiation.ArgumentReader;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class DynamicInstantiationMapAssemblerImpl
implements DomainResultAssembler {
    private final BasicJavaDescriptor<Map> mapJavaDescriptor;
    private final List<ArgumentReader> argumentReaders;

    public DynamicInstantiationMapAssemblerImpl(BasicJavaDescriptor<Map> mapJavaDescriptor, List<ArgumentReader> argumentReaders) {
        this.mapJavaDescriptor = mapJavaDescriptor;
        this.argumentReaders = argumentReaders;
        HashSet<String> aliases = new HashSet<String>();
        for (ArgumentReader argumentReader : argumentReaders) {
            if (argumentReader.getAlias() == null) {
                throw new IllegalStateException("alias for Map dynamic instantiation argument cannot be null");
            }
            if (aliases.add(argumentReader.getAlias())) continue;
            throw new IllegalStateException("Encountered duplicate alias for Map dynamic instantiation argument [" + argumentReader.getAlias() + "]");
        }
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.mapJavaDescriptor;
    }

    @Override
    public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (ArgumentReader argumentReader : this.argumentReaders) {
            result.put(argumentReader.getAlias(), argumentReader.assemble(rowProcessingState, options));
        }
        return result;
    }
}

