/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.values;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.results.spi.ResultSetAccess;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public abstract class AbstractResultSetAccess
implements ResultSetAccess {
    private final SharedSessionContractImplementor persistenceContext;
    private ResultSetMetaData resultSetMetaData;

    public AbstractResultSetAccess(SharedSessionContractImplementor persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    protected SharedSessionContractImplementor getPersistenceContext() {
        return this.persistenceContext;
    }

    protected ResultSetMetaData getMetaData() {
        if (this.resultSetMetaData == null) {
            try {
                this.resultSetMetaData = this.getResultSet().getMetaData();
            }
            catch (SQLException e) {
                throw this.persistenceContext.getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to access ResultSetMetaData");
            }
        }
        return this.resultSetMetaData;
    }

    @Override
    public int getColumnCount() {
        try {
            return this.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to access ResultSet column count");
        }
    }

    @Override
    public int resolveColumnPosition(String columnName) {
        try {
            return this.getResultSet().findColumn(columnName);
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to find column position by name");
        }
    }

    @Override
    public String resolveColumnName(int position) {
        try {
            return this.getFactory().getJdbcServices().getJdbcEnvironment().getDialect().getColumnAliasExtractor().extractColumnAlias(this.getMetaData(), position);
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to find column name by position");
        }
    }

    @Override
    public SqlTypeDescriptor resolveSqlTypeDescriptor(int position) {
        try {
            return this.getFactory().getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(this.getMetaData().getColumnType(position));
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to determine JDBC type code for ResultSet position " + position);
        }
    }
}

