/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.values;

import java.util.List;
import org.hibernate.sql.results.internal.caching.QueryCachePutManagerDisabledImpl;
import org.hibernate.sql.results.internal.values.AbstractJdbcValues;
import org.hibernate.sql.results.spi.ResultSetMapping;
import org.hibernate.sql.results.spi.RowProcessingState;

public class JdbcValuesCacheHit
extends AbstractJdbcValues {
    private Object[][] cachedData;
    private final int numberOfRows;
    private ResultSetMapping resolvedResultSetMapping;
    private int position = -1;

    public JdbcValuesCacheHit(Object[][] cachedData, ResultSetMapping resolvedResultSetMapping) {
        super(QueryCachePutManagerDisabledImpl.INSTANCE);
        this.cachedData = cachedData;
        this.numberOfRows = cachedData.length;
        this.resolvedResultSetMapping = resolvedResultSetMapping;
    }

    public JdbcValuesCacheHit(List<Object[]> cachedResults, ResultSetMapping resolvedResultSetMapping) {
        this((Object[][])cachedResults.toArray(), resolvedResultSetMapping);
    }

    @Override
    protected boolean processNext(RowProcessingState rowProcessingState) {
        if (this.isExhausted()) {
            return false;
        }
        ++this.position;
        return true;
    }

    private boolean isExhausted() {
        return this.position >= this.numberOfRows;
    }

    @Override
    public ResultSetMapping getResultSetMapping() {
        return this.resolvedResultSetMapping;
    }

    @Override
    public Object[] getCurrentRowValuesArray() {
        if (this.isExhausted()) {
            return null;
        }
        return this.cachedData[this.position];
    }

    @Override
    protected void release() {
        this.cachedData = null;
    }
}

