/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.values;

import java.sql.SQLException;
import org.hibernate.CacheMode;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.query.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.internal.caching.QueryCachePutManager;
import org.hibernate.sql.results.internal.caching.QueryCachePutManagerDisabledImpl;
import org.hibernate.sql.results.internal.caching.QueryCachePutManagerEnabledImpl;
import org.hibernate.sql.results.internal.values.AbstractJdbcValues;
import org.hibernate.sql.results.spi.ResultSetAccess;
import org.hibernate.sql.results.spi.ResultSetMapping;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.sql.results.spi.SqlSelection;

public class JdbcValuesResultSetImpl
extends AbstractJdbcValues {
    private final ResultSetAccess resultSetAccess;
    private final ResultSetMapping resultSetMapping;
    private final ExecutionContext executionContext;
    private final int numberOfRowsToProcess;
    private int position = -1;
    private Object[] currentRowJdbcValues;

    public JdbcValuesResultSetImpl(ResultSetAccess resultSetAccess, QueryKey queryCacheKey, QueryOptions queryOptions, ResultSetMapping resultSetMapping, ExecutionContext executionContext) {
        super(JdbcValuesResultSetImpl.resolveQueryCachePutManager(executionContext, queryOptions, queryCacheKey));
        this.resultSetAccess = resultSetAccess;
        this.resultSetMapping = resultSetMapping;
        this.executionContext = executionContext;
        this.numberOfRowsToProcess = JdbcValuesResultSetImpl.interpretNumberOfRowsToProcess(queryOptions);
    }

    private static int interpretNumberOfRowsToProcess(QueryOptions queryOptions) {
        if (queryOptions.getLimit() == null) {
            return -1;
        }
        Limit limit = queryOptions.getLimit();
        if (limit.getMaxRows() == null) {
            return -1;
        }
        return limit.getMaxRows();
    }

    private static QueryCachePutManager resolveQueryCachePutManager(ExecutionContext executionContext, QueryOptions queryOptions, QueryKey queryCacheKey) {
        boolean queryCacheEnabled = executionContext.getSession().getFactory().getSessionFactoryOptions().isQueryCacheEnabled();
        CacheMode cacheMode = queryOptions.getCacheMode();
        if (queryCacheEnabled && cacheMode.isPutEnabled()) {
            QueryResultsCache queryCache = executionContext.getSession().getFactory().getCache().getQueryResultsCache(queryOptions.getResultCacheRegionName());
            return new QueryCachePutManagerEnabledImpl(queryCache, queryCacheKey);
        }
        return QueryCachePutManagerDisabledImpl.INSTANCE;
    }

    @Override
    protected final boolean processNext(RowProcessingState rowProcessingState) {
        this.currentRowJdbcValues = null;
        if (this.numberOfRowsToProcess != -1 && this.position > this.numberOfRowsToProcess) {
            return false;
        }
        ++this.position;
        try {
            if (!this.resultSetAccess.getResultSet().next()) {
                return false;
            }
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error advancing JDBC ResultSet", e);
        }
        try {
            this.currentRowJdbcValues = this.readCurrentRowValues(rowProcessingState);
            return true;
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error reading JDBC row values", e);
        }
    }

    private ExecutionException makeExecutionException(String message, SQLException cause) {
        return new ExecutionException(message, (Throwable)((Object)this.executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert(cause, message)));
    }

    private Object[] readCurrentRowValues(RowProcessingState rowProcessingState) throws SQLException {
        int numberOfSqlSelections = this.resultSetMapping.getSqlSelections().size();
        Object[] row = new Object[numberOfSqlSelections];
        for (SqlSelection sqlSelection : this.resultSetMapping.getSqlSelections()) {
            row[sqlSelection.getValuesArrayPosition()] = sqlSelection.getJdbcValueExtractor().extract(this.resultSetAccess.getResultSet(), sqlSelection.getJdbcResultSetIndex(), this.executionContext);
        }
        return row;
    }

    @Override
    protected void release() {
        this.resultSetAccess.release();
    }

    @Override
    public ResultSetMapping getResultSetMapping() {
        return this.resultSetMapping;
    }

    @Override
    public Object[] getCurrentRowValuesArray() {
        return this.currentRowJdbcValues;
    }
}

