/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.results.internal.BiDirectionalFetchImpl;
import org.hibernate.sql.results.internal.RootBiDirectionalFetchImpl;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class CircularFetchDetector {
    public Fetch findBiDirectionalFetch(FetchParent fetchParent, Fetchable fetchable) {
        boolean isCircular;
        NavigablePath parentParentPath = fetchParent.getNavigablePath().getParent();
        if (parentParentPath != null && (isCircular = fetchable.isCircular(fetchParent))) {
            if (fetchParent instanceof Fetch) {
                FetchParent parentFetchParent = ((Fetch)((Object)fetchParent)).getFetchParent();
                NavigablePath fetchableNavigablePath = fetchParent.getNavigablePath().append(fetchable.getNavigableRole().getNavigableName());
                return new BiDirectionalFetchImpl(parentFetchParent, fetchableNavigablePath);
            }
            return new RootBiDirectionalFetchImpl(new NavigablePath(fetchable.getJavaTypeDescriptor().getJavaType().getName()), (JavaTypeDescriptor)fetchable.getJavaTypeDescriptor(), new NavigablePath(fetchable.getNavigableName()));
        }
        return null;
    }
}

