/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.internal.PersistentArrayDescriptorImpl;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.spi.CollectionInitializer;

public class LoadingCollectionEntry {
    private final PersistentCollectionDescriptor collectionDescriptor;
    private final CollectionInitializer initializer;
    private final Object key;
    private final PersistentCollection collectionInstance;

    public LoadingCollectionEntry(PersistentCollectionDescriptor collectionDescriptor, CollectionInitializer initializer, Object key, PersistentCollection collectionInstance) {
        this.collectionDescriptor = collectionDescriptor;
        this.initializer = initializer;
        this.key = key;
        this.collectionInstance = collectionInstance;
        collectionInstance.beforeInitialize(-1, this.getCollectionDescriptor());
        collectionInstance.beginRead();
    }

    public PersistentCollectionDescriptor getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    public CollectionInitializer getInitializer() {
        return this.initializer;
    }

    public Object getKey() {
        return this.key;
    }

    public PersistentCollection getCollectionInstance() {
        return this.collectionInstance;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getCollectionDescriptor().getNavigableRole().getFullPath() + "#" + this.getKey() + ")";
    }

    public void finishLoading(ExecutionContext executionContext) {
        this.collectionInstance.endRead();
        SharedSessionContractImplementor session = executionContext.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        CollectionEntry collectionEntry = persistenceContext.getCollectionEntry(this.collectionInstance);
        if (collectionEntry == null) {
            collectionEntry = persistenceContext.addInitializedCollection(this.getCollectionDescriptor(), this.getCollectionInstance(), this.getKey());
        } else {
            collectionEntry.postInitialize(this.collectionInstance);
        }
        if (this.getCollectionDescriptor() instanceof PersistentArrayDescriptorImpl) {
            persistenceContext.addCollectionHolder(this.collectionInstance);
        }
    }
}

