/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.results.spi.ResultSetMappingDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public interface ResultSetAccess
extends ResultSetMappingDescriptor.JdbcValuesMetadata {
    public ResultSet getResultSet();

    public SessionFactoryImplementor getFactory();

    public void release();

    @Override
    default public int getColumnCount() {
        try {
            return this.getResultSet().getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to access ResultSet column count");
        }
    }

    @Override
    default public int resolveColumnPosition(String columnName) {
        try {
            return this.getResultSet().findColumn(columnName);
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to find column position by name");
        }
    }

    @Override
    default public String resolveColumnName(int position) {
        try {
            return this.getFactory().getJdbcServices().getJdbcEnvironment().getDialect().getColumnAliasExtractor().extractColumnAlias(this.getResultSet().getMetaData(), position);
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to find column name by position");
        }
    }

    @Override
    default public SqlTypeDescriptor resolveSqlTypeDescriptor(int position) {
        try {
            return this.getFactory().getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(this.getResultSet().getMetaData().getColumnType(position));
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to determine JDBC type code for ResultSet position " + position);
        }
    }
}

