/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.metamodel.model.relational.spi.DatabaseModel;
import org.hibernate.metamodel.model.relational.spi.PhysicalNamingStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;

public class SchemaValidator {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(SchemaValidator.class);
    protected final DatabaseModel databaseModel;
    protected final ServiceRegistry serviceRegistry;

    public SchemaValidator(DatabaseModel databaseModel, ServiceRegistry serviceRegistry) {
        this.databaseModel = databaseModel;
        this.serviceRegistry = serviceRegistry;
    }

    public void validate() {
        LOG.runningSchemaValidator();
        ConfigurationService cfgService = this.serviceRegistry.getService(ConfigurationService.class);
        SchemaManagementTool tool = this.serviceRegistry.getService(SchemaManagementTool.class);
        ExecutionOptions executionOptions = SchemaManagementToolCoordinator.buildExecutionOptions(cfgService.getSettings());
        tool.getSchemaValidator(this.databaseModel, cfgService.getSettings()).doValidation(executionOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLineArgs parsedArgs = CommandLineArgs.parseCommandLineArgs(args);
            StandardServiceRegistry serviceRegistry = SchemaValidator.buildStandardServiceRegistry(parsedArgs);
            try {
                MetadataImplementor metadata = SchemaValidator.buildMetadata(parsedArgs, serviceRegistry);
                new SchemaValidator(Helper.buildDatabaseModel(serviceRegistry, metadata), serviceRegistry).validate();
            }
            finally {
                StandardServiceRegistryBuilder.destroy(serviceRegistry);
            }
        }
        catch (Exception e) {
            LOG.unableToRunSchemaUpdate(e);
        }
    }

    private static StandardServiceRegistry buildStandardServiceRegistry(CommandLineArgs parsedArgs) throws Exception {
        BootstrapServiceRegistry bsr = new BootstrapServiceRegistryBuilder().build();
        StandardServiceRegistryBuilder ssrBuilder = new StandardServiceRegistryBuilder(bsr);
        if (parsedArgs.cfgXmlFile != null) {
            ssrBuilder.configure(parsedArgs.cfgXmlFile);
        }
        if (parsedArgs.propertiesFile != null) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(parsedArgs.propertiesFile));
            ssrBuilder.applySettings(properties);
        }
        return ssrBuilder.build();
    }

    private static MetadataImplementor buildMetadata(CommandLineArgs parsedArgs, StandardServiceRegistry serviceRegistry) throws Exception {
        MetadataSources metadataSources = new MetadataSources(serviceRegistry);
        for (String filename : parsedArgs.hbmXmlFiles) {
            metadataSources.addFile(filename);
        }
        for (String filename : parsedArgs.jarFiles) {
            metadataSources.addJar(new File(filename));
        }
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        StrategySelector strategySelector = serviceRegistry.getService(StrategySelector.class);
        if (parsedArgs.implicitNamingStrategy != null) {
            metadataBuilder.applyImplicitNamingStrategy((ImplicitNamingStrategy)strategySelector.resolveStrategy(ImplicitNamingStrategy.class, parsedArgs.implicitNamingStrategy));
        }
        if (parsedArgs.physicalNamingStrategy != null) {
            metadataBuilder.applyPhysicalNamingStrategy((PhysicalNamingStrategy)strategySelector.resolveStrategy(org.hibernate.boot.model.naming.PhysicalNamingStrategy.class, parsedArgs.physicalNamingStrategy));
        }
        return (MetadataImplementor)metadataBuilder.build();
    }

    private static class CommandLineArgs {
        String implicitNamingStrategy = null;
        String physicalNamingStrategy = null;
        String propertiesFile = null;
        String cfgXmlFile = null;
        List<String> hbmXmlFiles = new ArrayList<String>();
        List<String> jarFiles = new ArrayList<String>();

        private CommandLineArgs() {
        }

        public static CommandLineArgs parseCommandLineArgs(String[] args) {
            CommandLineArgs parsedArgs = new CommandLineArgs();
            for (String arg : args) {
                if (arg.startsWith("--")) {
                    if (arg.startsWith("--properties=")) {
                        parsedArgs.propertiesFile = arg.substring(13);
                        continue;
                    }
                    if (arg.startsWith("--config=")) {
                        parsedArgs.cfgXmlFile = arg.substring(9);
                        continue;
                    }
                    if (arg.startsWith("--naming=")) {
                        DeprecationLogger.DEPRECATION_LOGGER.logDeprecatedNamingStrategyArgument();
                        continue;
                    }
                    if (arg.startsWith("--implicit-naming=")) {
                        parsedArgs.implicitNamingStrategy = arg.substring(18);
                        continue;
                    }
                    if (!arg.startsWith("--physical-naming=")) continue;
                    parsedArgs.physicalNamingStrategy = arg.substring(18);
                    continue;
                }
                if (arg.endsWith(".jar")) {
                    parsedArgs.jarFiles.add(arg);
                    continue;
                }
                parsedArgs.hbmXmlFiles.add(arg);
            }
            return parsedArgs;
        }
    }
}

