/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.naming.Identifier;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;

public class ExtractionContextImpl
implements ExtractionContext {
    private final ServiceRegistry serviceRegistry;
    private final JdbcEnvironment jdbcEnvironment;
    private final JdbcConnectionAccess jdbcConnectionAccess;
    private final ExtractionContext.DatabaseObjectAccess registeredTableAccess;
    private final Identifier defaultCatalogName;
    private final Identifier defaultSchemaName;
    private Connection jdbcConnection;
    private DatabaseMetaData jdbcDatabaseMetaData;

    public ExtractionContextImpl(ServiceRegistry serviceRegistry, JdbcEnvironment jdbcEnvironment, JdbcConnectionAccess jdbcConnectionAccess, ExtractionContext.DatabaseObjectAccess registeredTableAccess, Identifier defaultCatalogName, Identifier defaultSchemaName) {
        this.serviceRegistry = serviceRegistry;
        this.jdbcEnvironment = jdbcEnvironment;
        this.jdbcConnectionAccess = jdbcConnectionAccess;
        this.registeredTableAccess = registeredTableAccess;
        this.defaultCatalogName = defaultCatalogName;
        this.defaultSchemaName = defaultSchemaName;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public JdbcEnvironment getJdbcEnvironment() {
        return this.jdbcEnvironment;
    }

    @Override
    public Connection getJdbcConnection() {
        if (this.jdbcConnection == null) {
            try {
                this.jdbcConnection = this.jdbcConnectionAccess.obtainConnection();
            }
            catch (SQLException e) {
                throw this.jdbcEnvironment.getSqlExceptionHelper().convert(e, "Unable to obtain JDBC Connection");
            }
        }
        return this.jdbcConnection;
    }

    @Override
    public DatabaseMetaData getJdbcDatabaseMetaData() {
        if (this.jdbcDatabaseMetaData == null) {
            try {
                this.jdbcDatabaseMetaData = this.getJdbcConnection().getMetaData();
            }
            catch (SQLException e) {
                throw this.jdbcEnvironment.getSqlExceptionHelper().convert(e, "Unable to obtain JDBC DatabaseMetaData");
            }
        }
        return this.jdbcDatabaseMetaData;
    }

    @Override
    public Identifier getDefaultCatalog() {
        return this.defaultCatalogName;
    }

    @Override
    public Identifier getDefaultSchema() {
        return this.defaultSchemaName;
    }

    @Override
    public ExtractionContext.DatabaseObjectAccess getDatabaseObjectAccess() {
        return this.registeredTableAccess;
    }

    @Override
    public void cleanup() {
        if (this.jdbcDatabaseMetaData != null) {
            this.jdbcDatabaseMetaData = null;
        }
        if (this.jdbcConnection != null) {
            try {
                this.jdbcConnectionAccess.releaseConnection(this.jdbcConnection);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

