/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.naming.QualifiedSequenceName;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationImpl;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;

public class SequenceInformationExtractorMariaDBDatabaseImpl
extends SequenceInformationExtractorLegacyImpl {
    public static final SequenceInformationExtractorMariaDBDatabaseImpl INSTANCE = new SequenceInformationExtractorMariaDBDatabaseImpl();
    private static final String SQL_SEQUENCE_QUERY = "SELECT '%1$s' as sequence_name, minimum_value, maximum_value, start_value, increment, cache_size FROM %1$s ";
    private static final String UNION_ALL = "UNION ALL ";

    @Override
    public Iterable<SequenceInformation> extractMetadata(ExtractionContext extractionContext) throws SQLException {
        Throwable throwable;
        String lookupSql = extractionContext.getJdbcEnvironment().getDialect().getQuerySequencesString();
        if (lookupSql == null) {
            return SequenceInformationExtractorNoOpImpl.INSTANCE.extractMetadata(extractionContext);
        }
        IdentifierHelper identifierHelper = extractionContext.getJdbcEnvironment().getIdentifierHelper();
        ArrayList<SequenceInformation> sequenceInformationList = new ArrayList<SequenceInformation>();
        ArrayList<String> sequenceNames = new ArrayList<String>();
        Statement statement = extractionContext.getJdbcConnection().createStatement();
        Object object = null;
        try {
            throwable = null;
            try (ResultSet resultSet = statement.executeQuery(lookupSql);){
                while (resultSet.next()) {
                    sequenceNames.add(this.resultSetSequenceName(resultSet));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable resultSet) {
            object = resultSet;
            throw resultSet;
        }
        finally {
            if (statement != null) {
                if (object != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable resultSet) {
                        ((Throwable)object).addSuppressed(resultSet);
                    }
                } else {
                    statement.close();
                }
            }
        }
        if (!sequenceNames.isEmpty()) {
            StringBuilder sequenceInfoQueryBuilder = new StringBuilder();
            for (String sequenceName : sequenceNames) {
                if (sequenceInfoQueryBuilder.length() > 0) {
                    sequenceInfoQueryBuilder.append(UNION_ALL);
                }
                sequenceInfoQueryBuilder.append(String.format(SQL_SEQUENCE_QUERY, sequenceName));
            }
            boolean index = false;
            throwable = null;
            try (Statement statement2 = extractionContext.getJdbcConnection().createStatement();
                 ResultSet resultSet = statement2.executeQuery(sequenceInfoQueryBuilder.toString());){
                while (resultSet.next()) {
                    SequenceInformationImpl sequenceInformation = new SequenceInformationImpl(new QualifiedSequenceName(null, null, identifierHelper.toIdentifier(this.resultSetSequenceName(resultSet))), this.resultSetStartValueSize(resultSet), this.resultSetMinValue(resultSet), this.resultSetMaxValue(resultSet), this.resultSetIncrementValue(resultSet));
                    sequenceInformationList.add(sequenceInformation);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        return sequenceInformationList;
    }

    @Override
    protected String resultSetSequenceName(ResultSet resultSet) throws SQLException {
        return resultSet.getString(1);
    }

    @Override
    protected String sequenceCatalogColumn() {
        return null;
    }

    @Override
    protected String sequenceSchemaColumn() {
        return null;
    }
}

