/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.spi;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.hibernate.Incubating;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.QualifiedSequenceName;
import org.hibernate.naming.QualifiedTableName;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;

@Incubating
public interface ExtractionContext {
    public ServiceRegistry getServiceRegistry();

    public JdbcEnvironment getJdbcEnvironment();

    public Connection getJdbcConnection();

    public DatabaseMetaData getJdbcDatabaseMetaData();

    public Identifier getDefaultCatalog();

    public Identifier getDefaultSchema();

    public DatabaseObjectAccess getDatabaseObjectAccess();

    public void cleanup();

    public static abstract class EmptyExtractionContext
    implements ExtractionContext {
        @Override
        public ServiceRegistry getServiceRegistry() {
            return null;
        }

        @Override
        public JdbcEnvironment getJdbcEnvironment() {
            return null;
        }

        @Override
        public Connection getJdbcConnection() {
            return null;
        }

        @Override
        public DatabaseMetaData getJdbcDatabaseMetaData() {
            return null;
        }

        @Override
        public Identifier getDefaultCatalog() {
            return null;
        }

        @Override
        public Identifier getDefaultSchema() {
            return null;
        }

        @Override
        public DatabaseObjectAccess getDatabaseObjectAccess() {
            return null;
        }

        @Override
        public void cleanup() {
        }
    }

    @Incubating
    public static interface DatabaseObjectAccess {
        public TableInformation locateTableInformation(QualifiedTableName var1);

        public SequenceInformation locateSequenceInformation(QualifiedSequenceName var1);
    }
}

