/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.relational.spi.AuxiliaryDatabaseObject;
import org.hibernate.metamodel.model.relational.spi.DatabaseModel;
import org.hibernate.metamodel.model.relational.spi.Exportable;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.metamodel.model.relational.spi.Index;
import org.hibernate.metamodel.model.relational.spi.Namespace;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.metamodel.model.relational.spi.PhysicalTable;
import org.hibernate.metamodel.model.relational.spi.Sequence;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.metamodel.model.relational.spi.UniqueKey;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.NamespaceName;
import org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.hibernate.tool.hbm2ddl.UniqueConstraintSchemaUpdateStrategy;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.extract.spi.ForeignKeyInformation;
import org.hibernate.tool.schema.extract.spi.IndexInformation;
import org.hibernate.tool.schema.extract.spi.NameSpaceTablesInformation;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.hibernate.tool.schema.internal.DefaultSchemaFilter;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.IndividuallySchemaMigratorImpl;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.tool.schema.spi.SchemaFilter;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaMigrator;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.jboss.logging.Logger;

public abstract class AbstractSchemaMigrator
implements SchemaMigrator {
    private static final Logger log = Logger.getLogger(IndividuallySchemaMigratorImpl.class);
    protected final HibernateSchemaManagementTool tool;
    protected final SchemaFilter schemaFilter;
    protected final DatabaseModel databaseModel;
    protected final JdbcServices jdbcServices;
    private UniqueConstraintSchemaUpdateStrategy uniqueConstraintStrategy;

    public AbstractSchemaMigrator(HibernateSchemaManagementTool tool, DatabaseModel databaseModel, SchemaFilter schemaFilter) {
        this.tool = tool;
        this.databaseModel = databaseModel;
        this.schemaFilter = schemaFilter == null ? DefaultSchemaFilter.INSTANCE : schemaFilter;
        this.jdbcServices = tool.getServiceRegistry().getService(JdbcServices.class);
    }

    public void setUniqueConstraintStrategy(UniqueConstraintSchemaUpdateStrategy uniqueConstraintStrategy) {
        this.uniqueConstraintStrategy = uniqueConstraintStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doMigration(ExecutionOptions options, TargetDescriptor targetDescriptor) {
        if (!targetDescriptor.getTargetTypes().isEmpty()) {
            JdbcContext jdbcContext = this.tool.resolveJdbcContext(options.getConfigurationValues());
            DdlTransactionIsolator ddlTransactionIsolator = this.tool.getDdlTransactionIsolator(jdbcContext);
            try {
                DatabaseInformation databaseInformation = Helper.buildDatabaseInformation(this.tool.getServiceRegistry(), ddlTransactionIsolator, this.databaseModel.getDefaultNamespace());
                GenerationTarget[] targets = this.tool.buildGenerationTargets(targetDescriptor, ddlTransactionIsolator, options.getConfigurationValues());
                try {
                    for (GenerationTarget target : targets) {
                        target.prepare();
                    }
                    try {
                        this.performMigration(databaseInformation, options, jdbcContext.getDialect(), targets);
                    }
                    finally {
                        for (GenerationTarget target : targets) {
                            try {
                                target.release();
                            }
                            catch (Exception e) {
                                log.debugf("Problem releasing GenerationTarget [%s] : %s", (Object)target, (Object)e.getMessage());
                            }
                        }
                    }
                }
                finally {
                    try {
                        databaseInformation.cleanup();
                    }
                    catch (Exception e) {
                        log.debug((Object)("Problem releasing DatabaseInformation : " + e.getMessage()));
                    }
                }
            }
            finally {
                ddlTransactionIsolator.release();
            }
        }
    }

    protected abstract NameSpaceTablesInformation performTablesMigration(DatabaseInformation var1, ExecutionOptions var2, Dialect var3, Formatter var4, Set<String> var5, boolean var6, boolean var7, Set<Identifier> var8, Namespace var9, GenerationTarget[] var10);

    private void performMigration(DatabaseInformation existingDatabase, ExecutionOptions options, Dialect dialect, GenerationTarget ... targets) {
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        Formatter formatter = format ? FormatStyle.DDL.getFormatter() : FormatStyle.NONE.getFormatter();
        HashMap<NamespaceName, NameSpaceTablesInformation> tablesInformation = new HashMap<NamespaceName, NameSpaceTablesInformation>();
        HashSet<Identifier> exportedCatalogs = new HashSet<Identifier>();
        HashSet<String> exportIdentifiers = new HashSet<String>(50);
        this.dropAuxiliaryDatabaseObjects(options, dialect, formatter, targets);
        this.createBeforeTableCreationAuxiliaryDatabaseObjects(options, formatter, targets);
        boolean tryToCreateCatalogs = false;
        boolean tryToCreateSchemas = false;
        if (options.shouldManageNamespaces()) {
            if (dialect.canCreateSchema()) {
                tryToCreateSchemas = true;
            }
            if (dialect.canCreateCatalog()) {
                tryToCreateCatalogs = true;
            }
        }
        for (Namespace namespace : this.databaseModel.getNamespaces()) {
            NameSpaceTablesInformation nameSpaceTablesInformation = this.performTablesMigration(existingDatabase, options, dialect, formatter, exportIdentifiers, tryToCreateCatalogs, tryToCreateSchemas, exportedCatalogs, namespace, targets);
            tablesInformation.put(namespace.getName(), nameSpaceTablesInformation);
            this.createSequences(existingDatabase, options, dialect, formatter, exportIdentifiers, namespace, targets);
        }
        for (Namespace namespace : this.databaseModel.getNamespaces()) {
            this.createForeignKeys(options, dialect, formatter, tablesInformation, namespace, targets);
        }
        this.createAfterTableCreationAuxiliaryDatabaseObjects(options, formatter, targets);
    }

    private void createSequences(DatabaseInformation existingDatabase, ExecutionOptions options, Dialect dialect, Formatter formatter, Set<String> exportIdentifiers, Namespace namespace, GenerationTarget[] targets) {
        if (this.schemaFilter.includeNamespace(namespace)) {
            for (Sequence sequence : namespace.getSequences()) {
                this.checkExportIdentifier(sequence, exportIdentifiers);
                SequenceInformation sequenceInformation = existingDatabase.getSequenceInformation(sequence.getQualifiedName());
                if (sequenceInformation != null) continue;
                AbstractSchemaMigrator.applySqlStrings(false, dialect.getSequenceExporter().getSqlCreateStrings(sequence, this.jdbcServices), formatter, options, targets);
            }
        }
    }

    private void createForeignKeys(ExecutionOptions options, Dialect dialect, Formatter formatter, Map<NamespaceName, NameSpaceTablesInformation> tablesInformation, Namespace namespace, GenerationTarget[] targets) {
        if (this.schemaFilter.includeNamespace(namespace)) {
            NameSpaceTablesInformation nameSpaceTablesInformation = tablesInformation.get(namespace.getName());
            for (Table table : namespace.getTables()) {
                TableInformation tableInformation;
                ExportableTable exportableTable;
                if (!table.isExportable() || !this.schemaFilter.includeTable(exportableTable = (ExportableTable)table) || (tableInformation = nameSpaceTablesInformation.getTableInformation(exportableTable)) != null && !tableInformation.isPhysicalTable()) continue;
                this.applyForeignKeys(exportableTable, tableInformation, dialect, formatter, options, targets);
            }
        }
    }

    private void createAfterTableCreationAuxiliaryDatabaseObjects(ExecutionOptions options, Formatter formatter, GenerationTarget[] targets) {
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : this.databaseModel.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.isBeforeTablesOnCreation()) continue;
            AbstractSchemaMigrator.applySqlStrings(true, auxiliaryDatabaseObject.getSqlCreateStrings(), formatter, options, targets);
        }
    }

    private void createBeforeTableCreationAuxiliaryDatabaseObjects(ExecutionOptions options, Formatter formatter, GenerationTarget[] targets) {
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : this.databaseModel.getAuxiliaryDatabaseObjects()) {
            if (auxiliaryDatabaseObject.isBeforeTablesOnCreation()) continue;
            AbstractSchemaMigrator.applySqlStrings(true, auxiliaryDatabaseObject.getSqlCreateStrings(), formatter, options, targets);
        }
    }

    private void dropAuxiliaryDatabaseObjects(ExecutionOptions options, Dialect dialect, Formatter formatter, GenerationTarget[] targets) {
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : this.databaseModel.getAuxiliaryDatabaseObjects()) {
            AbstractSchemaMigrator.applySqlStrings(true, dialect.getAuxiliaryDatabaseObjectExporter().getSqlDropStrings(auxiliaryDatabaseObject, this.jdbcServices), formatter, options, targets);
        }
    }

    protected void createTable(ExportableTable table, Dialect dialect, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        AbstractSchemaMigrator.applySqlStrings(false, dialect.getTableExporter().getSqlCreateStrings(table, this.jdbcServices), formatter, options, targets);
    }

    protected void migrateTable(ExportableTable table, TableInformation tableInformation, Dialect dialect, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        AbstractSchemaMigrator.applySqlStrings(false, dialect.getTableAlterable().getSqlAlterStrings(table, tableInformation, this.jdbcServices), formatter, options, targets);
    }

    protected void applyIndexes(ExportableTable table, TableInformation tableInformation, Dialect dialect, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        Exporter<Index> exporter = dialect.getIndexExporter();
        for (Index index : table.getIndexes()) {
            if (index.getName() != null) continue;
            IndexInformation existingIndex = null;
            if (tableInformation != null) {
                existingIndex = this.findMatchingIndex(index, tableInformation);
            }
            if (existingIndex != null) continue;
            AbstractSchemaMigrator.applySqlStrings(false, exporter.getSqlCreateStrings(index, this.jdbcServices), formatter, options, targets);
        }
    }

    private IndexInformation findMatchingIndex(Index index, TableInformation tableInformation) {
        return tableInformation.getIndex(index.getName());
    }

    protected void applyUniqueKeys(ExportableTable table, TableInformation tableInfo, Dialect dialect, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (this.uniqueConstraintStrategy == null) {
            this.uniqueConstraintStrategy = this.determineUniqueConstraintSchemaUpdateStrategy();
        }
        if (this.uniqueConstraintStrategy != UniqueConstraintSchemaUpdateStrategy.SKIP) {
            Exporter<UniqueKey> exporter = dialect.getUniqueKeyExporter();
            for (UniqueKey uniqueKey : table.getUniqueKeys()) {
                IndexInformation indexInfo = null;
                if (tableInfo != null && uniqueKey.getName() != null) {
                    indexInfo = tableInfo.getIndex(uniqueKey.getName());
                }
                if (indexInfo != null) continue;
                if (this.uniqueConstraintStrategy == UniqueConstraintSchemaUpdateStrategy.DROP_RECREATE_QUIETLY) {
                    AbstractSchemaMigrator.applySqlStrings(true, exporter.getSqlDropStrings(uniqueKey, this.jdbcServices), formatter, options, targets);
                }
                AbstractSchemaMigrator.applySqlStrings(true, exporter.getSqlCreateStrings(uniqueKey, this.jdbcServices), formatter, options, targets);
            }
        }
    }

    private UniqueConstraintSchemaUpdateStrategy determineUniqueConstraintSchemaUpdateStrategy() {
        ConfigurationService cfgService = this.tool.getServiceRegistry().getService(ConfigurationService.class);
        return UniqueConstraintSchemaUpdateStrategy.interpret(cfgService.getSetting("hibernate.schema_update.unique_constraint_strategy", StandardConverters.STRING));
    }

    protected void applyForeignKeys(ExportableTable table, TableInformation tableInformation, Dialect dialect, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (dialect.hasAlterTable()) {
            Exporter<ForeignKey> exporter = dialect.getForeignKeyExporter();
            for (ForeignKey foreignKey : table.getForeignKeys()) {
                if (!foreignKey.isExportationEnabled()) continue;
                boolean existingForeignKeyFound = false;
                if (tableInformation != null) {
                    existingForeignKeyFound = this.checkForExistingForeignKey(foreignKey, tableInformation);
                }
                if (existingForeignKeyFound) continue;
                AbstractSchemaMigrator.applySqlStrings(false, exporter.getSqlCreateStrings(foreignKey, this.jdbcServices), formatter, options, targets);
            }
        }
    }

    private boolean checkForExistingForeignKey(ForeignKey foreignKey, TableInformation tableInformation) {
        if (foreignKey.getName() == null || tableInformation == null) {
            return false;
        }
        String referencingColumn = ((PhysicalColumn)foreignKey.getColumnMappings().getColumnMappings().get(0).getReferringColumn()).getName().getText();
        String referencedTable = ((PhysicalTable)foreignKey.getTargetTable()).getTableName().getText();
        Predicate<ForeignKeyInformation.ColumnReferenceMapping> mappingPredicate = m -> {
            String existingReferencingColumn = m.getReferencingColumnMetadata().getColumnIdentifier().getText();
            String existingReferencedTable = m.getReferencedColumnMetadata().getContainingTableInformation().getName().getTableName().getCanonicalName();
            return referencingColumn.equals(existingReferencingColumn) && referencedTable.equals(existingReferencedTable);
        };
        Stream<ForeignKeyInformation> keyStream = StreamSupport.stream(tableInformation.getForeignKeys().spliterator(), false);
        Stream mappingStream = keyStream.flatMap(k -> StreamSupport.stream(k.getColumnReferenceMappings().spliterator(), false));
        boolean found = mappingStream.anyMatch(mappingPredicate);
        if (found) {
            return true;
        }
        return tableInformation.getForeignKey(Identifier.toIdentifier(foreignKey.getName())) != null;
    }

    protected void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException(String.format("Export identifier [%s] encountered more than once", exportIdentifier));
        }
        exportIdentifiers.add(exportIdentifier);
    }

    protected void createSchemaAndCatalog(DatabaseInformation existingDatabase, ExecutionOptions options, Dialect dialect, Formatter formatter, boolean tryToCreateCatalogs, boolean tryToCreateSchemas, Set<Identifier> exportedCatalogs, Namespace namespace, GenerationTarget[] targets) {
        if (tryToCreateCatalogs || tryToCreateSchemas) {
            if (tryToCreateCatalogs) {
                Identifier catalogLogicalName = namespace.getCatalogName();
                Identifier catalogPhysicalName = namespace.getCatalogName();
                if (catalogPhysicalName != null && !exportedCatalogs.contains(catalogLogicalName) && !existingDatabase.catalogExists(catalogLogicalName)) {
                    AbstractSchemaMigrator.applySqlStrings(false, dialect.getCreateCatalogCommand(catalogPhysicalName.render(dialect)), formatter, options, targets);
                    exportedCatalogs.add(catalogLogicalName);
                }
            }
            if (tryToCreateSchemas && namespace.getSchemaName() != null && !existingDatabase.schemaExists(namespace)) {
                AbstractSchemaMigrator.applySqlStrings(false, dialect.getCreateSchemaCommand(namespace.getSchemaName().render(dialect)), formatter, options, targets);
            }
        }
    }

    protected static void applySqlStrings(boolean quiet, String[] sqlStrings, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (sqlStrings != null) {
            for (String sqlString : sqlStrings) {
                AbstractSchemaMigrator.applySqlString(quiet, sqlString, formatter, options, targets);
            }
        }
    }

    private static void applySqlString(boolean quiet, String sqlString, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (!StringHelper.isEmpty(sqlString)) {
            String sqlStringFormatted = formatter.format(sqlString);
            for (GenerationTarget target : targets) {
                try {
                    target.accept(sqlStringFormatted);
                }
                catch (CommandAcceptanceException e) {
                    if (quiet) continue;
                    options.getExceptionHandler().handleException(e);
                }
            }
        }
    }
}

