/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.Set;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.metamodel.model.relational.spi.DatabaseModel;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.Namespace;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.naming.Identifier;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.extract.spi.NameSpaceTablesInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.hibernate.tool.schema.internal.AbstractSchemaMigrator;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaFilter;

public class GroupedSchemaMigratorImpl
extends AbstractSchemaMigrator {
    public GroupedSchemaMigratorImpl(HibernateSchemaManagementTool tool, DatabaseModel databaseModel, SchemaFilter schemaFilter) {
        super(tool, databaseModel, schemaFilter);
    }

    @Override
    protected NameSpaceTablesInformation performTablesMigration(DatabaseInformation existingDatabase, ExecutionOptions options, Dialect dialect, Formatter formatter, Set<String> exportIdentifiers, boolean tryToCreateCatalogs, boolean tryToCreateSchemas, Set<Identifier> exportedCatalogs, Namespace namespace, GenerationTarget[] targets) {
        NameSpaceTablesInformation tablesInformation = new NameSpaceTablesInformation(this.databaseModel.getJdbcEnvironment().getIdentifierHelper());
        if (this.schemaFilter.includeNamespace(namespace)) {
            TableInformation tableInformation;
            ExportableTable exportableTable;
            this.createSchemaAndCatalog(existingDatabase, options, dialect, formatter, tryToCreateCatalogs, tryToCreateSchemas, exportedCatalogs, namespace, targets);
            NameSpaceTablesInformation tables = existingDatabase.getTablesInformation(namespace);
            for (Table table : namespace.getTables()) {
                if (!table.isExportable() || !this.schemaFilter.includeTable(exportableTable = (ExportableTable)table)) continue;
                this.checkExportIdentifier(exportableTable, exportIdentifiers);
                tableInformation = tables.getTableInformation(exportableTable);
                if (tableInformation == null) {
                    this.createTable(exportableTable, dialect, formatter, options, targets);
                    continue;
                }
                if (!tableInformation.isPhysicalTable()) continue;
                tablesInformation.addTableInformation(tableInformation);
                this.migrateTable(exportableTable, tableInformation, dialect, formatter, options, targets);
            }
            for (Table table : namespace.getTables()) {
                if (!table.isExportable() || !this.schemaFilter.includeTable(exportableTable = (ExportableTable)table) || (tableInformation = tablesInformation.getTableInformation(exportableTable)) != null && !tableInformation.isPhysicalTable()) continue;
                this.applyIndexes(exportableTable, tableInformation, dialect, formatter, options, targets);
                this.applyUniqueKeys(exportableTable, tableInformation, dialect, formatter, options, targets);
            }
        }
        return tablesInformation;
    }
}

