/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.model.relational.spi.DatabaseModel;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.Namespace;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.hibernate.tool.schema.internal.AbstractSchemaValidator;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaFilter;

public class IndividuallySchemaValidatorImpl
extends AbstractSchemaValidator {
    public IndividuallySchemaValidatorImpl(HibernateSchemaManagementTool tool, DatabaseModel databaseModel, SchemaFilter validateFilter) {
        super(tool, databaseModel, validateFilter);
    }

    @Override
    protected void validateTables(DatabaseInformation databaseInformation, ExecutionOptions options, Dialect dialect, Namespace namespace) {
        for (Table table : namespace.getTables()) {
            ExportableTable exportableTable;
            if (!table.isExportable() || !this.schemaFilter.includeTable(exportableTable = (ExportableTable)table)) continue;
            TableInformation tableInformation = databaseInformation.getTableInformation(exportableTable.getQualifiedTableName());
            this.validateTable(exportableTable, tableInformation, options, dialect);
        }
    }
}

