/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.relational.spi.Index;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.naming.QualifiedNameImpl;
import org.hibernate.tool.schema.spi.Exporter;

public class StandardIndexExporter
implements Exporter<Index> {
    private final Dialect dialect;

    public StandardIndexExporter(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String[] getSqlCreateStrings(Index index, JdbcServices jdbcServices) {
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        String tableName = jdbcEnvironment.getQualifiedObjectNameFormatter().format(index.getTable().getQualifiedTableName(), this.dialect);
        String indexNameForCreation = this.dialect.qualifyIndexName() ? jdbcEnvironment.getQualifiedObjectNameFormatter().format(new QualifiedNameImpl(index.getTable().getQualifiedTableName().getCatalogName(), index.getTable().getQualifiedTableName().getSchemaName(), index.getName()), jdbcEnvironment.getDialect()) : index.getName().render(jdbcEnvironment.getDialect());
        StringBuilder buf = new StringBuilder().append("create index ").append(indexNameForCreation).append(" on ").append(tableName).append(" (");
        boolean first = true;
        for (PhysicalColumn column : index.getColumns()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(column.getName().render(jdbcEnvironment.getDialect()));
            String orderMap = index.getColumnOrderMap(column);
            if (!StringHelper.isNotEmpty(orderMap)) continue;
            buf.append(" ").append(orderMap);
        }
        buf.append(")");
        return new String[]{buf.toString()};
    }

    @Override
    public String[] getSqlDropStrings(Index index, JdbcServices jdbcServices) {
        if (!this.dialect.dropConstraints()) {
            return NO_COMMANDS;
        }
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        String tableName = jdbcEnvironment.getQualifiedObjectNameFormatter().format(index.getTable().getQualifiedTableName(), this.dialect);
        String indexNameForCreation = this.dialect.qualifyIndexName() ? StringHelper.qualify(tableName, index.getName().render(this.dialect)) : index.getName().render(this.dialect);
        return new String[]{"drop index " + indexNameForCreation};
    }
}

