/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.metamodel.model.relational.spi.Sequence;
import org.hibernate.tool.schema.spi.Exporter;

public class StandardSequenceExporter
implements Exporter<Sequence> {
    private final Dialect dialect;

    public StandardSequenceExporter(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String[] getSqlCreateStrings(Sequence sequence, JdbcServices jdbcServices) {
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        return this.dialect.getCreateSequenceStrings(jdbcEnvironment.getQualifiedObjectNameFormatter().format(sequence.getQualifiedName(), jdbcEnvironment.getDialect()), sequence.getInitialValue(), sequence.getIncrementSize());
    }

    @Override
    public String[] getSqlDropStrings(Sequence sequence, JdbcServices jdbcServices) {
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        return this.dialect.getDropSequenceStrings(jdbcEnvironment.getQualifiedObjectNameFormatter().format(sequence.getQualifiedName(), jdbcEnvironment.getDialect()));
    }
}

