/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.Collection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.tool.schema.extract.spi.ColumnInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.hibernate.tool.schema.spi.Alterable;
import org.jboss.logging.Logger;

public class StandardTableAlterable
implements Alterable<ExportableTable> {
    private static final Logger log = Logger.getLogger(StandardTableAlterable.class);
    protected final Dialect dialect;

    public StandardTableAlterable(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String[] getSqlAlterStrings(ExportableTable table, TableInformation tableInfo, JdbcServices jdbcServices) {
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        StringBuilder root = new StringBuilder(this.dialect.getAlterTableString(jdbcEnvironment.getQualifiedObjectNameFormatter().format(table.getQualifiedTableName(), jdbcEnvironment.getDialect()))).append(' ').append(this.dialect.getAddColumnString());
        Collection<PhysicalColumn> physicalColumns = table.getPhysicalColumns();
        String[] results = new String[physicalColumns.size()];
        int i = 0;
        for (PhysicalColumn physicalColumn : physicalColumns) {
            String columnComment;
            ColumnInformation columnInfo = tableInfo.getColumn(physicalColumn.getName());
            if (columnInfo != null) continue;
            StringBuilder alter = new StringBuilder(root.toString()).append(' ').append(physicalColumn.getName().render(this.dialect)).append(' ').append(physicalColumn.getSqlTypeName());
            String defaultValue = physicalColumn.getDefaultValue();
            if (defaultValue != null) {
                alter.append(" default ").append(defaultValue);
            }
            if (physicalColumn.isNullable()) {
                alter.append(this.dialect.getNullColumnString());
            } else {
                alter.append(" not null");
            }
            if (physicalColumn.isUnique()) {
                alter.append(this.dialect.getUniqueDelegate().getColumnDefinitionUniquenessFragment(physicalColumn));
            }
            if (physicalColumn.getCheckConstraint() != null && this.dialect.supportsColumnCheck()) {
                alter.append(" check(").append(physicalColumn.getCheckConstraint()).append(")");
            }
            if ((columnComment = physicalColumn.getComment()) != null) {
                alter.append(this.dialect.getColumnComment(columnComment));
            }
            alter.append(this.dialect.getAddColumnSuffixString());
            results[i] = alter.toString();
            ++i;
        }
        if (results.length == 0) {
            log.debugf("No alter strings for table : %s", (Object)table.getTableName().render(this.dialect));
        }
        return results;
    }
}

