/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.naming.spi.QualifiedName;
import org.hibernate.naming.spi.QualifiedNameParser;
import org.hibernate.tool.schema.spi.Exporter;

public class StandardTableExporter
implements Exporter<ExportableTable> {
    protected final Dialect dialect;

    public StandardTableExporter(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String[] getSqlCreateStrings(ExportableTable table, JdbcServices jdbcServices) {
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        StringBuilder buf = new StringBuilder(this.tableCreateString(table.hasPrimaryKey())).append(' ').append(jdbcEnvironment.getQualifiedObjectNameFormatter().format(table.getQualifiedTableName(), jdbcEnvironment.getDialect())).append(" (");
        String pkColName = null;
        if (table.hasPrimaryKey()) {
            PhysicalColumn pkColumn = table.getPrimaryKey().getColumns().iterator().next();
            pkColName = pkColumn.getName().render();
        }
        boolean isFirst = true;
        for (PhysicalColumn col : table.getPhysicalColumns()) {
            String columnComment;
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            String colName = col.getName().render(this.dialect);
            buf.append(colName).append(' ');
            if (table.isPrimaryKeyIdentity() && colName.equals(pkColName)) {
                if (this.dialect.getIdentityColumnSupport().hasDataTypeInIdentityColumn()) {
                    buf.append(this.dialect.getTypeName(col.getSqlTypeDescriptor().getJdbcTypeCode()));
                }
                buf.append(' ').append(this.dialect.getIdentityColumnSupport().getIdentityColumnString(col.getSqlTypeDescriptor().getJdbcTypeCode()));
            } else {
                buf.append(col.getSqlTypeName());
                String defaultValue = col.getDefaultValue();
                if (defaultValue != null) {
                    buf.append(" default ").append(defaultValue);
                }
                if (col.isNullable()) {
                    buf.append(this.dialect.getNullColumnString());
                } else {
                    buf.append(" not null");
                }
            }
            if (col.isUnique()) {
                buf.append(this.dialect.getUniqueDelegate().getColumnDefinitionUniquenessFragment(col));
            }
            if (col.getCheckConstraint() != null && this.dialect.supportsColumnCheck()) {
                buf.append(" check (").append(col.getCheckConstraint()).append(")");
            }
            if ((columnComment = col.getComment()) == null) continue;
            buf.append(this.dialect.getColumnComment(columnComment));
        }
        if (table.hasPrimaryKey()) {
            this.appendPrimaryKey(table, buf);
        }
        buf.append(this.dialect.getUniqueDelegate().getTableCreationUniqueConstraintsFragment(table));
        this.applyTableCheck(table, buf);
        buf.append(')');
        if (table.getComment() != null) {
            buf.append(this.dialect.getTableComment(table.getComment()));
        }
        this.applyTableTypeString(buf);
        ArrayList<String> sqlStrings = new ArrayList<String>();
        sqlStrings.add(buf.toString());
        this.applyComments(table, table.getQualifiedTableName(), sqlStrings);
        this.applyInitCommands(table, sqlStrings);
        return sqlStrings.toArray(new String[sqlStrings.size()]);
    }

    @Override
    public String[] getSqlDropStrings(ExportableTable table, JdbcServices jdbcServices) {
        StringBuilder buf = new StringBuilder("drop table ");
        if (this.dialect.supportsIfExistsBeforeTableName()) {
            buf.append("if exists ");
        }
        QualifiedNameParser.NameParts tableName = new QualifiedNameParser.NameParts(table.getCatalogName(), table.getSchemaName(), table.getTableName());
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        buf.append(jdbcEnvironment.getQualifiedObjectNameFormatter().format(tableName, jdbcEnvironment.getDialect())).append(this.dialect.getCascadeConstraintsString());
        if (this.dialect.supportsIfExistsAfterTableName()) {
            buf.append(" if exists");
        }
        return new String[]{buf.toString()};
    }

    private void appendPrimaryKey(ExportableTable table, StringBuilder buf) {
        buf.append(", primary key (");
        boolean firstColumn = true;
        for (PhysicalColumn column : table.getPrimaryKey().getColumns()) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                buf.append(", ");
            }
            buf.append(column.getName().render(this.dialect));
        }
        buf.append(')');
    }

    protected void applyComments(ExportableTable table, QualifiedName tableName, List<String> sqlStrings) {
        if (this.dialect.supportsCommentOn()) {
            if (table.getComment() != null) {
                sqlStrings.add("comment on table " + tableName + " is '" + table.getComment() + "'");
            }
            for (PhysicalColumn column : table.getPhysicalColumns()) {
                String columnComment;
                if (!PhysicalColumn.class.isInstance(column) || (columnComment = column.getComment()) == null) continue;
                sqlStrings.add("comment on column " + tableName + '.' + column.getName().render(this.dialect) + " is '" + columnComment + "'");
            }
        }
    }

    protected void applyInitCommands(ExportableTable table, List<String> sqlStrings) {
        for (InitCommand initCommand : table.getInitCommands()) {
            Collections.addAll(sqlStrings, initCommand.getInitCommands());
        }
    }

    protected void applyTableTypeString(StringBuilder buf) {
        buf.append(this.dialect.getTableTypeString());
    }

    protected void applyTableCheck(ExportableTable table, StringBuilder buf) {
        if (this.dialect.supportsTableCheck()) {
            Iterator<String> checkConstraints = table.getCheckConstraints().iterator();
            while (checkConstraints.hasNext()) {
                buf.append(", check (").append(checkConstraints.next()).append(')');
            }
        }
    }

    protected String tableCreateString(boolean hasPrimaryKey) {
        return hasPrimaryKey ? this.dialect.getCreateTableString() : this.dialect.getCreateMultisetTableString();
    }
}

