/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.internal;

import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.persistence.TemporalType;

public final class DateTimeUtils {
    public static final String FORMAT_STRING_TIMESTAMP = "yyyy-MM-dd HH:mm:ss.S";
    public static final String FORMAT_STRING_DATE = "yyyy-MM-dd";
    public static final String FORMAT_STRING_TIME = "HH:mm:ss";
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIME = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ENGLISH);
    public static final String JDBC_ESCAPE_START_TIMESTAMP = "{ts '";
    public static final String JDBC_ESCAPE_START_DATE = "{d '";
    public static final String JDBC_ESCAPE_START_TIME = "{t '";
    public static final String JDBC_ESCAPE_END = "'}";

    private DateTimeUtils() {
    }

    public static String formatUsingPrecision(TemporalAccessor temporalAccessor, TemporalType precision) {
        switch (precision) {
            case DATE: {
                return DateTimeUtils.formatAsDate(temporalAccessor);
            }
            case TIME: {
                return DateTimeUtils.formatAsTime(temporalAccessor);
            }
        }
        return DateTimeUtils.formatAsTimestamp(temporalAccessor);
    }

    public static String formatAsTimestamp(TemporalAccessor temporalAccessor) {
        return DATE_TIME_FORMATTER_TIMESTAMP.format(temporalAccessor);
    }

    public static String formatAsDate(TemporalAccessor temporalAccessor) {
        return DATE_TIME_FORMATTER_DATE.format(temporalAccessor);
    }

    public static String formatAsTime(TemporalAccessor temporalAccessor) {
        return DATE_TIME_FORMATTER_TIME.format(temporalAccessor);
    }

    public static String formatJdbcLiteralUsingPrecision(TemporalAccessor temporalAccessor, TemporalType precision) {
        switch (precision) {
            case DATE: {
                return DateTimeUtils.formatAsJdbcLiteralDate(temporalAccessor);
            }
            case TIME: {
                return DateTimeUtils.formatAsJdbcLiteralTime(temporalAccessor);
            }
        }
        return DateTimeUtils.formatAsJdbcLiteralTimestamp(temporalAccessor);
    }

    public static String formatAsJdbcLiteralDate(TemporalAccessor temporalAccessor) {
        return DateTimeUtils.wrapAsJdbcDateLiteral(DateTimeUtils.formatAsDate(temporalAccessor));
    }

    public static String wrapAsJdbcDateLiteral(String literal) {
        return JDBC_ESCAPE_START_DATE + literal + JDBC_ESCAPE_END;
    }

    public static String formatAsJdbcLiteralTime(TemporalAccessor temporalAccessor) {
        return DateTimeUtils.wrapAsJdbcTimeLiteral(DateTimeUtils.formatAsTime(temporalAccessor));
    }

    public static String wrapAsJdbcTimeLiteral(String literal) {
        return JDBC_ESCAPE_START_TIME + literal + JDBC_ESCAPE_END;
    }

    public static String formatAsJdbcLiteralTimestamp(TemporalAccessor temporalAccessor) {
        return DateTimeUtils.wrapAsJdbcTimestampLiteral(DateTimeUtils.formatAsTimestamp(temporalAccessor));
    }

    public static String wrapAsJdbcTimestampLiteral(String literal) {
        return JDBC_ESCAPE_START_TIMESTAMP + literal + JDBC_ESCAPE_END;
    }

    public static String formatUsingPrecision(Date date, TemporalType precision) {
        switch (precision) {
            case DATE: {
                return DateTimeUtils.formatAsDate(date);
            }
            case TIME: {
                return DateTimeUtils.formatAsTime(date);
            }
        }
        return DateTimeUtils.formatAsTimestamp(date);
    }

    public static String formatAsTimestamp(Date date) {
        return DateTimeUtils.simpleDateFormatTimestamp().format(date);
    }

    public static SimpleDateFormat simpleDateFormatTimestamp() {
        return new SimpleDateFormat(FORMAT_STRING_TIMESTAMP, Locale.ENGLISH);
    }

    public static String formatAsDate(Date date) {
        return DateTimeUtils.simpleDateFormatDate().format(date);
    }

    public static SimpleDateFormat simpleDateFormatDate() {
        return new SimpleDateFormat(FORMAT_STRING_DATE, Locale.ENGLISH);
    }

    public static String formatAsTime(Date date) {
        return DateTimeUtils.simpleDateFormatTime().format(date);
    }

    public static SimpleDateFormat simpleDateFormatTime() {
        return new SimpleDateFormat(FORMAT_STRING_TIME, Locale.ENGLISH);
    }

    public static String formatJdbcLiteralUsingPrecision(Date date, TemporalType precision) {
        switch (precision) {
            case DATE: {
                return DateTimeUtils.formatAsJdbcLiteralDate(date);
            }
            case TIME: {
                return DateTimeUtils.formatAsJdbcLiteralTime(date);
            }
        }
        return DateTimeUtils.formatAsJdbcLiteralTimestamp(date);
    }

    public static String formatAsJdbcLiteralDate(Date date) {
        return DateTimeUtils.wrapAsJdbcDateLiteral(DateTimeUtils.formatAsDate(date));
    }

    public static String formatAsJdbcLiteralTime(Date date) {
        return DateTimeUtils.wrapAsJdbcTimeLiteral(DateTimeUtils.formatAsTime(date));
    }

    public static String formatAsJdbcLiteralTimestamp(Date date) {
        return DateTimeUtils.wrapAsJdbcTimestampLiteral(DateTimeUtils.formatAsTimestamp(date));
    }

    public static String formatUsingPrecision(Calendar calendar, TemporalType precision) {
        switch (precision) {
            case DATE: {
                return DateTimeUtils.formatAsDate(calendar);
            }
            case TIME: {
                return DateTimeUtils.formatAsTime(calendar);
            }
        }
        return DateTimeUtils.formatAsTimestamp(calendar);
    }

    public static String formatAsTimestamp(Calendar calendar) {
        return DateTimeUtils.simpleDateFormatTimestamp(calendar.getTimeZone()).format(calendar.getTime());
    }

    public static SimpleDateFormat simpleDateFormatTimestamp(TimeZone timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_STRING_TIMESTAMP, Locale.ENGLISH);
        formatter.setTimeZone(timeZone);
        return formatter;
    }

    public static String formatAsDate(Calendar calendar) {
        return DateTimeUtils.simpleDateFormatDate(calendar.getTimeZone()).format(calendar.getTime());
    }

    public static SimpleDateFormat simpleDateFormatDate(TimeZone timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_STRING_DATE, Locale.ENGLISH);
        formatter.setTimeZone(timeZone);
        return formatter;
    }

    public static String formatAsTime(Calendar calendar) {
        return DateTimeUtils.simpleDateFormatTime(calendar.getTimeZone()).format(calendar.getTime());
    }

    public static SimpleDateFormat simpleDateFormatTime(TimeZone timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_STRING_TIME, Locale.ENGLISH);
        formatter.setTimeZone(timeZone);
        return formatter;
    }

    public static String formatJdbcLiteralUsingPrecision(Calendar calendar, TemporalType precision) {
        switch (precision) {
            case DATE: {
                return DateTimeUtils.formatAsJdbcLiteralDate(calendar);
            }
            case TIME: {
                return DateTimeUtils.formatAsJdbcLiteralTime(calendar);
            }
        }
        return DateTimeUtils.formatAsJdbcLiteralTimestamp(calendar);
    }

    public static String formatAsJdbcLiteralTimestamp(Calendar calendar) {
        return DateTimeUtils.wrapAsJdbcTimestampLiteral(DateTimeUtils.formatAsTimestamp(calendar));
    }

    public static String formatAsJdbcLiteralDate(Calendar calendar) {
        return DateTimeUtils.wrapAsJdbcDateLiteral(DateTimeUtils.formatAsDate(calendar));
    }

    public static String formatAsJdbcLiteralTime(Calendar calendar) {
        return DateTimeUtils.wrapAsJdbcTimeLiteral(DateTimeUtils.formatAsTime(calendar));
    }
}

