/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.ImmutableMutabilityPlan;

public interface JavaTypeDescriptor<T>
extends Serializable {
    public String getTypeName();

    public Class<T> getJavaType();

    default public MutabilityPlan<T> getMutabilityPlan() {
        return ImmutableMutabilityPlan.INSTANCE;
    }

    default public Comparator<T> getComparator() {
        return Comparable.class.isAssignableFrom(Comparable.class) ? ComparableComparator.INSTANCE : null;
    }

    default public int extractHashCode(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Value to extract hashCode from cannot be null");
        }
        return value.hashCode();
    }

    default public boolean areEqual(T one, T another) {
        return Objects.deepEquals(one, another);
    }

    public String extractLoggableRepresentation(T var1);
}

