/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.BlobImplementer;
import org.hibernate.engine.jdbc.BlobProxy;
import org.hibernate.engine.jdbc.WrappedBlob;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.internal.LobStreamDataHelper;
import org.hibernate.type.descriptor.java.internal.PrimitiveByteArrayJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.spi.IncomparableComparator;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class BlobJavaDescriptor
extends AbstractBasicJavaDescriptor<Blob> {
    public static final BlobJavaDescriptor INSTANCE = new BlobJavaDescriptor();

    public BlobJavaDescriptor() {
        super(Blob.class, BlobMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Blob value) {
        byte[] bytes;
        try {
            bytes = LobStreamDataHelper.extractBytes(value.getBinaryStream());
        }
        catch (SQLException e) {
            throw new HibernateException("Unable to access blob stream", e);
        }
        return PrimitiveByteArrayJavaDescriptor.INSTANCE.toString(bytes);
    }

    @Override
    public Blob fromString(String string) {
        return BlobProxy.generateProxy(PrimitiveByteArrayJavaDescriptor.INSTANCE.fromString(string));
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(2004);
    }

    @Override
    public Comparator<Blob> getComparator() {
        return IncomparableComparator.INSTANCE;
    }

    @Override
    public int extractHashCode(Blob value) {
        return System.identityHashCode(value);
    }

    @Override
    public boolean areEqual(Blob one, Blob another) {
        return one == another;
    }

    @Override
    public <X> X unwrap(Blob value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        try {
            if (BinaryStream.class.isAssignableFrom(type)) {
                if (BlobImplementer.class.isInstance(value)) {
                    return (X)((BlobImplementer)((Object)value)).getUnderlyingStream();
                }
                return (X)new BinaryStreamImpl(LobStreamDataHelper.extractBytes(value.getBinaryStream()));
            }
            if (byte[].class.isAssignableFrom(type)) {
                if (BlobImplementer.class.isInstance(value)) {
                    return (X)((BlobImplementer)((Object)value)).getUnderlyingStream().getBytes();
                }
                return (X)LobStreamDataHelper.extractBytes(value.getBinaryStream());
            }
            if (Blob.class.isAssignableFrom(type)) {
                Blob blob = WrappedBlob.class.isInstance(value) ? ((WrappedBlob)((Object)value)).getWrappedBlob() : value;
                return (X)blob;
            }
        }
        catch (SQLException e) {
            throw new HibernateException("Unable to access blob stream", e);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Blob wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Blob.class.isAssignableFrom(value.getClass())) {
            return session.getLobCreator().wrap((Blob)value);
        }
        if (byte[].class.isAssignableFrom(value.getClass())) {
            return session.getLobCreator().createBlob((byte[])value);
        }
        if (InputStream.class.isAssignableFrom(value.getClass())) {
            InputStream inputStream = (InputStream)value;
            try {
                return session.getLobCreator().createBlob(inputStream, inputStream.available());
            }
            catch (IOException e) {
                throw this.unknownWrap(value.getClass());
            }
        }
        throw this.unknownWrap(value.getClass());
    }

    public static class BlobMutabilityPlan
    implements MutabilityPlan<Blob> {
        public static final BlobMutabilityPlan INSTANCE = new BlobMutabilityPlan();

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public Blob deepCopy(Blob value) {
            return value;
        }

        @Override
        public Serializable disassemble(Blob value) {
            throw new UnsupportedOperationException("Blobs are not cacheable");
        }

        @Override
        public Blob assemble(Serializable cached) {
            throw new UnsupportedOperationException("Blobs are not cacheable");
        }
    }
}

