/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.Primitive;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class BooleanJavaDescriptor
extends AbstractBasicJavaDescriptor<Boolean>
implements Primitive<Boolean> {
    public static final BooleanJavaDescriptor INSTANCE = new BooleanJavaDescriptor();

    public BooleanJavaDescriptor() {
        super(Boolean.class);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(context.getPreferredSqlTypeCodeForBoolean());
    }

    @Override
    public String toString(Boolean value) {
        return value == null ? null : value.toString();
    }

    @Override
    public Boolean fromString(String string) {
        return Boolean.valueOf(string);
    }

    public int toInt(Boolean value) {
        return value != false ? 1 : 0;
    }

    public Byte toByte(Boolean value) {
        return (byte)this.toInt(value);
    }

    public Short toShort(Boolean value) {
        return (short)this.toInt(value);
    }

    public Integer toInteger(Boolean value) {
        return this.toInt(value);
    }

    public Long toLong(Boolean value) {
        return this.toInt(value);
    }

    @Override
    public Class getPrimitiveClass() {
        return Boolean.TYPE;
    }

    @Override
    public Boolean getDefaultValue() {
        return Boolean.FALSE;
    }

    @Override
    public <X> X unwrap(Boolean value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (X)this.toByte(value);
        }
        if (Short.class.isAssignableFrom(type)) {
            return (X)this.toShort(value);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)this.toInteger(value);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)this.toLong(value);
        }
        if (Character.class.isAssignableFrom(type)) {
            char charValue = value != false ? (char)'T' : 'F';
            return (X)Character.valueOf(charValue);
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Boolean wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Boolean.class.isInstance(value)) {
            return (Boolean)value;
        }
        if (Number.class.isInstance(value)) {
            int intValue = ((Number)value).intValue();
            return intValue == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (Character.class.isInstance(value)) {
            return this.isTrue(((Character)value).charValue()) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (String.class.isInstance(value)) {
            return Boolean.valueOf((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    private boolean isTrue(char charValue) {
        return charValue == 'T';
    }
}

