/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.java.internal.LobStreamDataHelper;
import org.hibernate.type.descriptor.java.spi.AbstractBasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.ArrayMutabilityPlan;
import org.hibernate.type.descriptor.spi.IncomparableComparator;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class ByteArrayJavaDescriptor
extends AbstractBasicJavaDescriptor<Byte[]> {
    public static final ByteArrayJavaDescriptor INSTANCE = new ByteArrayJavaDescriptor();

    public ByteArrayJavaDescriptor() {
        super(Byte[].class, ArrayMutabilityPlan.INSTANCE);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        int jdbcCode = context.isLob() ? 2004 : -4;
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(jdbcCode);
    }

    @Override
    public int extractHashCode(Byte[] bytes) {
        int hashCode = 1;
        Byte[] byteArray = bytes;
        int n = byteArray.length;
        for (int i = 0; i < n; ++i) {
            byte aByte = byteArray[i];
            hashCode = 31 * hashCode + aByte;
        }
        return hashCode;
    }

    @Override
    public boolean areEqual(Byte[] one, Byte[] another) {
        return one == another || one != null && another != null && Arrays.equals((Object[])one, (Object[])another);
    }

    @Override
    public String toString(Byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (Byte aByte : bytes) {
            String hexStr = Integer.toHexString(aByte - -128);
            if (hexStr.length() == 1) {
                buf.append('0');
            }
            buf.append(hexStr);
        }
        return buf.toString();
    }

    @Override
    public Byte[] fromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("The string is not a valid string representation of a binary content.");
        }
        Byte[] bytes = new Byte[string.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            String hexStr = string.substring(i * 2, (i + 1) * 2);
            bytes[i] = (byte)(Integer.parseInt(hexStr, 16) + -128);
        }
        return bytes;
    }

    @Override
    public <X> X unwrap(Byte[] value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Byte[].class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (byte[].class.isAssignableFrom(type)) {
            return (X)this.unwrapBytes(value);
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return (X)new ByteArrayInputStream(this.unwrapBytes(value));
        }
        if (BinaryStream.class.isAssignableFrom(type)) {
            return (X)new BinaryStreamImpl(this.unwrapBytes(value));
        }
        if (Blob.class.isAssignableFrom(type)) {
            return (X)session.getLobCreator().createBlob(this.unwrapBytes(value));
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Byte[] wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Byte[].class.isInstance(value)) {
            return (Byte[])value;
        }
        if (byte[].class.isInstance(value)) {
            return this.wrapBytes((byte[])value);
        }
        if (InputStream.class.isInstance(value)) {
            return this.wrapBytes(LobStreamDataHelper.extractBytes((InputStream)value));
        }
        if (Blob.class.isInstance(value) || LobStreamDataHelper.isNClob(value.getClass())) {
            try {
                return this.wrapBytes(LobStreamDataHelper.extractBytes(((Blob)value).getBinaryStream()));
            }
            catch (SQLException e) {
                throw new HibernateException("Unable to access lob stream", e);
            }
        }
        throw this.unknownWrap(value.getClass());
    }

    private Byte[] wrapBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Byte[] result = new Byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = bytes[i];
        }
        return result;
    }

    private byte[] unwrapBytes(Byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = bytes[i];
        }
        return result;
    }

    @Override
    public Comparator<Byte[]> getComparator() {
        return IncomparableComparator.INSTANCE;
    }
}

