/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.internal;

import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.ByteVersionSupport;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.type.descriptor.java.spi.AbstractNumericJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.Primitive;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class ByteJavaDescriptor
extends AbstractNumericJavaDescriptor<Byte>
implements Primitive<Byte> {
    public static final ByteJavaDescriptor INSTANCE = new ByteJavaDescriptor();
    public static final Byte ZERO = 0;

    private ByteJavaDescriptor() {
        super(Byte.class);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(-6);
    }

    @Override
    public String toString(Byte value) {
        return value == null ? null : value.toString();
    }

    @Override
    public Byte fromString(String string) {
        return Byte.valueOf(string);
    }

    @Override
    public <X> X unwrap(Byte value, Class<X> type, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Short.class.isAssignableFrom(type)) {
            return (X)Short.valueOf(value.shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)Integer.valueOf(value.intValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.longValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            return (X)Double.valueOf(value.doubleValue());
        }
        if (Float.class.isAssignableFrom(type)) {
            return (X)Float.valueOf(value.floatValue());
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Byte wrap(X value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (Byte.class.isInstance(value)) {
            return (Byte)value;
        }
        if (Number.class.isInstance(value)) {
            return ((Number)value).byteValue();
        }
        if (String.class.isInstance(value)) {
            return Byte.valueOf((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public Class getPrimitiveClass() {
        return Byte.TYPE;
    }

    @Override
    public Byte getDefaultValue() {
        return ZERO;
    }

    @Override
    public VersionSupport<Byte> getVersionSupport() {
        return ByteVersionSupport.INSTANCE;
    }
}

